package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength64String,
  MaxResults,
  NonEmptyMaxLength1024String,
  AccountId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRegionalBucketsRequest(
    accountId: AccountId,
    nextToken: Optional[NonEmptyMaxLength1024String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    outpostId: Optional[NonEmptyMaxLength64String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest = {
    import ListRegionalBucketsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        outpostId.map(value =>
          NonEmptyMaxLength64String.unwrap(value): java.lang.String
        )
      )(_.outpostId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ListRegionalBucketsRequest.ReadOnly =
    zio.aws.s3control.model.ListRegionalBucketsRequest.wrap(buildAwsValue())
}
object ListRegionalBucketsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListRegionalBucketsRequest =
      zio.aws.s3control.model.ListRegionalBucketsRequest(
        accountId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        outpostId.map(value => value)
      )
    def accountId: AccountId
    def nextToken: Optional[NonEmptyMaxLength1024String]
    def maxResults: Optional[MaxResults]
    def outpostId: Optional[NonEmptyMaxLength64String]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getNextToken: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getOutpostId: ZIO[Any, AwsError, NonEmptyMaxLength64String] =
      AwsError.unwrapOptionField("outpostId", outpostId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest
  ) extends zio.aws.s3control.model.ListRegionalBucketsRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val nextToken: Optional[NonEmptyMaxLength1024String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.s3control.model.primitives.MaxResults(value))
    override val outpostId: Optional[NonEmptyMaxLength64String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outpostId())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength64String(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest
  ): zio.aws.s3control.model.ListRegionalBucketsRequest.ReadOnly = new Wrapper(
    impl
  )
}
