package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{JobFailureReason, JobFailureCode}
import scala.jdk.CollectionConverters._
final case class JobFailure(
    failureCode: Optional[JobFailureCode] = Optional.Absent,
    failureReason: Optional[JobFailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobFailure = {
    import JobFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobFailure
      .builder()
      .optionallyWith(
        failureCode.map(value => JobFailureCode.unwrap(value): java.lang.String)
      )(_.failureCode)
      .optionallyWith(
        failureReason.map(value =>
          JobFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobFailure.ReadOnly =
    zio.aws.s3control.model.JobFailure.wrap(buildAwsValue())
}
object JobFailure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobFailure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobFailure =
      zio.aws.s3control.model.JobFailure(
        failureCode.map(value => value),
        failureReason.map(value => value)
      )
    def failureCode: Optional[JobFailureCode]
    def failureReason: Optional[JobFailureReason]
    def getFailureCode: ZIO[Any, AwsError, JobFailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, JobFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobFailure
  ) extends zio.aws.s3control.model.JobFailure.ReadOnly {
    override val failureCode: Optional[JobFailureCode] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => zio.aws.s3control.model.primitives.JobFailureCode(value))
    override val failureReason: Optional[JobFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.s3control.model.primitives.JobFailureReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobFailure
  ): zio.aws.s3control.model.JobFailure.ReadOnly = new Wrapper(impl)
}
