package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class PutPublicAccessBlockRequest(
    publicAccessBlockConfiguration: zio.aws.s3control.model.PublicAccessBlockConfiguration,
    accountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest = {
    import PutPublicAccessBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest
      .builder()
      .publicAccessBlockConfiguration(
        publicAccessBlockConfiguration.buildAwsValue()
      )
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PutPublicAccessBlockRequest.ReadOnly =
    zio.aws.s3control.model.PutPublicAccessBlockRequest.wrap(buildAwsValue())
}
object PutPublicAccessBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PutPublicAccessBlockRequest =
      zio.aws.s3control.model.PutPublicAccessBlockRequest(
        publicAccessBlockConfiguration.asEditable,
        accountId
      )
    def publicAccessBlockConfiguration
        : zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    def accountId: AccountId
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = ZIO.succeed(publicAccessBlockConfiguration)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest
  ) extends zio.aws.s3control.model.PutPublicAccessBlockRequest.ReadOnly {
    override val publicAccessBlockConfiguration
        : zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly =
      zio.aws.s3control.model.PublicAccessBlockConfiguration
        .wrap(impl.publicAccessBlockConfiguration())
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest
  ): zio.aws.s3control.model.PutPublicAccessBlockRequest.ReadOnly = new Wrapper(
    impl
  )
}
