package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.Days
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NoncurrentVersionExpiration(
    noncurrentDays: Optional[Days] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration = {
    import NoncurrentVersionExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly =
    zio.aws.s3control.model.NoncurrentVersionExpiration.wrap(buildAwsValue())
}
object NoncurrentVersionExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.NoncurrentVersionExpiration =
      zio.aws.s3control.model
        .NoncurrentVersionExpiration(noncurrentDays.map(value => value))
    def noncurrentDays: Optional[Days]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ) extends zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly {
    override val noncurrentDays: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.noncurrentDays())
      .map(value => zio.aws.s3control.model.primitives.Days(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ): zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly = new Wrapper(
    impl
  )
}
