package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait OutputSchemaVersion {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.OutputSchemaVersion
}
object OutputSchemaVersion {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.OutputSchemaVersion
  ): zio.aws.s3control.model.OutputSchemaVersion = value match {
    case software.amazon.awssdk.services.s3control.model.OutputSchemaVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.OutputSchemaVersion.V_1 =>
      val r = V_1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.OutputSchemaVersion {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OutputSchemaVersion =
      software.amazon.awssdk.services.s3control.model.OutputSchemaVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object V_1 extends zio.aws.s3control.model.OutputSchemaVersion {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OutputSchemaVersion =
      software.amazon.awssdk.services.s3control.model.OutputSchemaVersion.V_1
  }
}
