package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  JobTerminationDate,
  JobPriority,
  JobId,
  NonEmptyMaxLength256String,
  JobCreationTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class JobListDescriptor(
    jobId: Optional[JobId] = Optional.Absent,
    description: Optional[NonEmptyMaxLength256String] = Optional.Absent,
    operation: Optional[zio.aws.s3control.model.OperationName] =
      Optional.Absent,
    priority: Optional[JobPriority] = Optional.Absent,
    status: Optional[zio.aws.s3control.model.JobStatus] = Optional.Absent,
    creationTime: Optional[JobCreationTime] = Optional.Absent,
    terminationDate: Optional[JobTerminationDate] = Optional.Absent,
    progressSummary: Optional[zio.aws.s3control.model.JobProgressSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobListDescriptor = {
    import JobListDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobListDescriptor
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        description.map(value =>
          NonEmptyMaxLength256String.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(operation.map(value => value.unwrap))(_.operation)
      .optionallyWith(
        priority.map(value => JobPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => JobCreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        terminationDate.map(value => JobTerminationDate.unwrap(value): Instant)
      )(_.terminationDate)
      .optionallyWith(progressSummary.map(value => value.buildAwsValue()))(
        _.progressSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobListDescriptor.ReadOnly =
    zio.aws.s3control.model.JobListDescriptor.wrap(buildAwsValue())
}
object JobListDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobListDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobListDescriptor =
      zio.aws.s3control.model.JobListDescriptor(
        jobId.map(value => value),
        description.map(value => value),
        operation.map(value => value),
        priority.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        terminationDate.map(value => value),
        progressSummary.map(value => value.asEditable)
      )
    def jobId: Optional[JobId]
    def description: Optional[NonEmptyMaxLength256String]
    def operation: Optional[zio.aws.s3control.model.OperationName]
    def priority: Optional[JobPriority]
    def status: Optional[zio.aws.s3control.model.JobStatus]
    def creationTime: Optional[JobCreationTime]
    def terminationDate: Optional[JobTerminationDate]
    def progressSummary
        : Optional[zio.aws.s3control.model.JobProgressSummary.ReadOnly]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getDescription: ZIO[Any, AwsError, NonEmptyMaxLength256String] =
      AwsError.unwrapOptionField("description", description)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.s3control.model.OperationName] =
      AwsError.unwrapOptionField("operation", operation)
    def getPriority: ZIO[Any, AwsError, JobPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getStatus: ZIO[Any, AwsError, zio.aws.s3control.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, JobCreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTerminationDate: ZIO[Any, AwsError, JobTerminationDate] =
      AwsError.unwrapOptionField("terminationDate", terminationDate)
    def getProgressSummary: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.JobProgressSummary.ReadOnly
    ] = AwsError.unwrapOptionField("progressSummary", progressSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobListDescriptor
  ) extends zio.aws.s3control.model.JobListDescriptor.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.s3control.model.primitives.JobId(value))
    override val description: Optional[NonEmptyMaxLength256String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength256String(value)
        )
    override val operation: Optional[zio.aws.s3control.model.OperationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.s3control.model.OperationName.wrap(value))
    override val priority: Optional[JobPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.s3control.model.primitives.JobPriority(value))
    override val status: Optional[zio.aws.s3control.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.s3control.model.JobStatus.wrap(value))
    override val creationTime: Optional[JobCreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.s3control.model.primitives.JobCreationTime(value))
    override val terminationDate: Optional[JobTerminationDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminationDate())
        .map(value =>
          zio.aws.s3control.model.primitives.JobTerminationDate(value)
        )
    override val progressSummary
        : Optional[zio.aws.s3control.model.JobProgressSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressSummary())
        .map(value => zio.aws.s3control.model.JobProgressSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobListDescriptor
  ): zio.aws.s3control.model.JobListDescriptor.ReadOnly = new Wrapper(impl)
}
