package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.Days
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NoncurrentVersionTransition(
    noncurrentDays: Optional[Days] = Optional.Absent,
    storageClass: Optional[zio.aws.s3control.model.TransitionStorageClass] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition = {
    import NoncurrentVersionTransition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly =
    zio.aws.s3control.model.NoncurrentVersionTransition.wrap(buildAwsValue())
}
object NoncurrentVersionTransition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.NoncurrentVersionTransition =
      zio.aws.s3control.model.NoncurrentVersionTransition(
        noncurrentDays.map(value => value),
        storageClass.map(value => value)
      )
    def noncurrentDays: Optional[Days]
    def storageClass: Optional[zio.aws.s3control.model.TransitionStorageClass]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3control.model.TransitionStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition
  ) extends zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly {
    override val noncurrentDays: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.noncurrentDays())
      .map(value => zio.aws.s3control.model.primitives.Days(value))
    override val storageClass
        : Optional[zio.aws.s3control.model.TransitionStorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value =>
          zio.aws.s3control.model.TransitionStorageClass.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionTransition
  ): zio.aws.s3control.model.NoncurrentVersionTransition.ReadOnly = new Wrapper(
    impl
  )
}
