package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class DeletePublicAccessBlockRequest(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest = {
    import DeletePublicAccessBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeletePublicAccessBlockRequest.ReadOnly =
    zio.aws.s3control.model.DeletePublicAccessBlockRequest.wrap(buildAwsValue())
}
object DeletePublicAccessBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.DeletePublicAccessBlockRequest =
      zio.aws.s3control.model.DeletePublicAccessBlockRequest(accountId)
    def accountId: AccountId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest
  ) extends zio.aws.s3control.model.DeletePublicAccessBlockRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest
  ): zio.aws.s3control.model.DeletePublicAccessBlockRequest.ReadOnly =
    new Wrapper(impl)
}
