package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength64String,
  S3RegionalBucketArn,
  PublicAccessBlockEnabled,
  BucketName,
  CreationDate
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RegionalBucket(
    bucket: BucketName,
    bucketArn: Optional[S3RegionalBucketArn] = Optional.Absent,
    publicAccessBlockEnabled: PublicAccessBlockEnabled,
    creationDate: CreationDate,
    outpostId: Optional[NonEmptyMaxLength64String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.RegionalBucket = {
    import RegionalBucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.RegionalBucket
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        bucketArn.map(value =>
          S3RegionalBucketArn.unwrap(value): java.lang.String
        )
      )(_.bucketArn)
      .publicAccessBlockEnabled(
        PublicAccessBlockEnabled.unwrap(
          publicAccessBlockEnabled
        ): java.lang.Boolean
      )
      .creationDate(CreationDate.unwrap(creationDate): Instant)
      .optionallyWith(
        outpostId.map(value =>
          NonEmptyMaxLength64String.unwrap(value): java.lang.String
        )
      )(_.outpostId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.RegionalBucket.ReadOnly =
    zio.aws.s3control.model.RegionalBucket.wrap(buildAwsValue())
}
object RegionalBucket {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.RegionalBucket
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.RegionalBucket =
      zio.aws.s3control.model.RegionalBucket(
        bucket,
        bucketArn.map(value => value),
        publicAccessBlockEnabled,
        creationDate,
        outpostId.map(value => value)
      )
    def bucket: BucketName
    def bucketArn: Optional[S3RegionalBucketArn]
    def publicAccessBlockEnabled: PublicAccessBlockEnabled
    def creationDate: CreationDate
    def outpostId: Optional[NonEmptyMaxLength64String]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getBucketArn: ZIO[Any, AwsError, S3RegionalBucketArn] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getPublicAccessBlockEnabled
        : ZIO[Any, Nothing, PublicAccessBlockEnabled] =
      ZIO.succeed(publicAccessBlockEnabled)
    def getCreationDate: ZIO[Any, Nothing, CreationDate] =
      ZIO.succeed(creationDate)
    def getOutpostId: ZIO[Any, AwsError, NonEmptyMaxLength64String] =
      AwsError.unwrapOptionField("outpostId", outpostId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.RegionalBucket
  ) extends zio.aws.s3control.model.RegionalBucket.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val bucketArn: Optional[S3RegionalBucketArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketArn())
        .map(value =>
          zio.aws.s3control.model.primitives.S3RegionalBucketArn(value)
        )
    override val publicAccessBlockEnabled: PublicAccessBlockEnabled =
      zio.aws.s3control.model.primitives
        .PublicAccessBlockEnabled(impl.publicAccessBlockEnabled())
    override val creationDate: CreationDate =
      zio.aws.s3control.model.primitives.CreationDate(impl.creationDate())
    override val outpostId: Optional[NonEmptyMaxLength64String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outpostId())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength64String(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.RegionalBucket
  ): zio.aws.s3control.model.RegionalBucket.ReadOnly = new Wrapper(impl)
}
