package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobOperation(
    lambdaInvoke: Optional[zio.aws.s3control.model.LambdaInvokeOperation] =
      Optional.Absent,
    s3PutObjectCopy: Optional[zio.aws.s3control.model.S3CopyObjectOperation] =
      Optional.Absent,
    s3PutObjectAcl: Optional[zio.aws.s3control.model.S3SetObjectAclOperation] =
      Optional.Absent,
    s3PutObjectTagging: Optional[
      zio.aws.s3control.model.S3SetObjectTaggingOperation
    ] = Optional.Absent,
    s3DeleteObjectTagging: Optional[
      zio.aws.s3control.model.S3DeleteObjectTaggingOperation
    ] = Optional.Absent,
    s3InitiateRestoreObject: Optional[
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation
    ] = Optional.Absent,
    s3PutObjectLegalHold: Optional[
      zio.aws.s3control.model.S3SetObjectLegalHoldOperation
    ] = Optional.Absent,
    s3PutObjectRetention: Optional[
      zio.aws.s3control.model.S3SetObjectRetentionOperation
    ] = Optional.Absent,
    s3ReplicateObject: Optional[
      zio.aws.s3control.model.S3ReplicateObjectOperation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobOperation = {
    import JobOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobOperation
      .builder()
      .optionallyWith(lambdaInvoke.map(value => value.buildAwsValue()))(
        _.lambdaInvoke
      )
      .optionallyWith(s3PutObjectCopy.map(value => value.buildAwsValue()))(
        _.s3PutObjectCopy
      )
      .optionallyWith(s3PutObjectAcl.map(value => value.buildAwsValue()))(
        _.s3PutObjectAcl
      )
      .optionallyWith(s3PutObjectTagging.map(value => value.buildAwsValue()))(
        _.s3PutObjectTagging
      )
      .optionallyWith(
        s3DeleteObjectTagging.map(value => value.buildAwsValue())
      )(_.s3DeleteObjectTagging)
      .optionallyWith(
        s3InitiateRestoreObject.map(value => value.buildAwsValue())
      )(_.s3InitiateRestoreObject)
      .optionallyWith(s3PutObjectLegalHold.map(value => value.buildAwsValue()))(
        _.s3PutObjectLegalHold
      )
      .optionallyWith(s3PutObjectRetention.map(value => value.buildAwsValue()))(
        _.s3PutObjectRetention
      )
      .optionallyWith(s3ReplicateObject.map(value => value.buildAwsValue()))(
        _.s3ReplicateObject
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobOperation.ReadOnly =
    zio.aws.s3control.model.JobOperation.wrap(buildAwsValue())
}
object JobOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobOperation =
      zio.aws.s3control.model.JobOperation(
        lambdaInvoke.map(value => value.asEditable),
        s3PutObjectCopy.map(value => value.asEditable),
        s3PutObjectAcl.map(value => value.asEditable),
        s3PutObjectTagging.map(value => value.asEditable),
        s3DeleteObjectTagging.map(value => value.asEditable),
        s3InitiateRestoreObject.map(value => value.asEditable),
        s3PutObjectLegalHold.map(value => value.asEditable),
        s3PutObjectRetention.map(value => value.asEditable),
        s3ReplicateObject.map(value => value.asEditable)
      )
    def lambdaInvoke
        : Optional[zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly]
    def s3PutObjectCopy
        : Optional[zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly]
    def s3PutObjectAcl
        : Optional[zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly]
    def s3PutObjectTagging
        : Optional[zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly]
    def s3DeleteObjectTagging: Optional[
      zio.aws.s3control.model.S3DeleteObjectTaggingOperation.ReadOnly
    ]
    def s3InitiateRestoreObject: Optional[
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly
    ]
    def s3PutObjectLegalHold: Optional[
      zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly
    ]
    def s3PutObjectRetention: Optional[
      zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly
    ]
    def s3ReplicateObject
        : Optional[zio.aws.s3control.model.S3ReplicateObjectOperation.ReadOnly]
    def getLambdaInvoke: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaInvoke", lambdaInvoke)
    def getS3PutObjectCopy: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectCopy", s3PutObjectCopy)
    def getS3PutObjectAcl: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectAcl", s3PutObjectAcl)
    def getS3PutObjectTagging: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectTagging", s3PutObjectTagging)
    def getS3DeleteObjectTagging: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3DeleteObjectTaggingOperation.ReadOnly
    ] =
      AwsError.unwrapOptionField("s3DeleteObjectTagging", s3DeleteObjectTagging)
    def getS3InitiateRestoreObject: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3InitiateRestoreObject",
      s3InitiateRestoreObject
    )
    def getS3PutObjectLegalHold: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectLegalHold", s3PutObjectLegalHold)
    def getS3PutObjectRetention: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectRetention", s3PutObjectRetention)
    def getS3ReplicateObject: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3ReplicateObjectOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3ReplicateObject", s3ReplicateObject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobOperation
  ) extends zio.aws.s3control.model.JobOperation.ReadOnly {
    override val lambdaInvoke
        : Optional[zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaInvoke())
        .map(value => zio.aws.s3control.model.LambdaInvokeOperation.wrap(value))
    override val s3PutObjectCopy
        : Optional[zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3PutObjectCopy())
        .map(value => zio.aws.s3control.model.S3CopyObjectOperation.wrap(value))
    override val s3PutObjectAcl
        : Optional[zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3PutObjectAcl())
        .map(value =>
          zio.aws.s3control.model.S3SetObjectAclOperation.wrap(value)
        )
    override val s3PutObjectTagging: Optional[
      zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3PutObjectTagging())
      .map(value =>
        zio.aws.s3control.model.S3SetObjectTaggingOperation.wrap(value)
      )
    override val s3DeleteObjectTagging: Optional[
      zio.aws.s3control.model.S3DeleteObjectTaggingOperation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3DeleteObjectTagging())
      .map(value =>
        zio.aws.s3control.model.S3DeleteObjectTaggingOperation.wrap(value)
      )
    override val s3InitiateRestoreObject: Optional[
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3InitiateRestoreObject())
      .map(value =>
        zio.aws.s3control.model.S3InitiateRestoreObjectOperation.wrap(value)
      )
    override val s3PutObjectLegalHold: Optional[
      zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3PutObjectLegalHold())
      .map(value =>
        zio.aws.s3control.model.S3SetObjectLegalHoldOperation.wrap(value)
      )
    override val s3PutObjectRetention: Optional[
      zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3PutObjectRetention())
      .map(value =>
        zio.aws.s3control.model.S3SetObjectRetentionOperation.wrap(value)
      )
    override val s3ReplicateObject: Optional[
      zio.aws.s3control.model.S3ReplicateObjectOperation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ReplicateObject())
      .map(value =>
        zio.aws.s3control.model.S3ReplicateObjectOperation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobOperation
  ): zio.aws.s3control.model.JobOperation.ReadOnly = new Wrapper(impl)
}
