package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StorageLensDataExportEncryption(
    sses3: Optional[zio.aws.s3control.model.SSES3] = Optional.Absent,
    ssekms: Optional[zio.aws.s3control.model.SSEKMS] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.StorageLensDataExportEncryption = {
    import StorageLensDataExportEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.StorageLensDataExportEncryption
      .builder()
      .optionallyWith(sses3.map(value => value.buildAwsValue()))(_.sses3)
      .optionallyWith(ssekms.map(value => value.buildAwsValue()))(_.ssekms)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.StorageLensDataExportEncryption.ReadOnly =
    zio.aws.s3control.model.StorageLensDataExportEncryption
      .wrap(buildAwsValue())
}
object StorageLensDataExportEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.StorageLensDataExportEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.StorageLensDataExportEncryption =
      zio.aws.s3control.model.StorageLensDataExportEncryption(
        sses3.map(value => value.asEditable),
        ssekms.map(value => value.asEditable)
      )
    def sses3: Optional[zio.aws.s3control.model.SSES3.ReadOnly]
    def ssekms: Optional[zio.aws.s3control.model.SSEKMS.ReadOnly]
    def getSses3: ZIO[Any, AwsError, zio.aws.s3control.model.SSES3.ReadOnly] =
      AwsError.unwrapOptionField("sses3", sses3)
    def getSsekms: ZIO[Any, AwsError, zio.aws.s3control.model.SSEKMS.ReadOnly] =
      AwsError.unwrapOptionField("ssekms", ssekms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensDataExportEncryption
  ) extends zio.aws.s3control.model.StorageLensDataExportEncryption.ReadOnly {
    override val sses3: Optional[zio.aws.s3control.model.SSES3.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sses3())
        .map(value => zio.aws.s3control.model.SSES3.wrap(value))
    override val ssekms: Optional[zio.aws.s3control.model.SSEKMS.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssekms())
        .map(value => zio.aws.s3control.model.SSEKMS.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensDataExportEncryption
  ): zio.aws.s3control.model.StorageLensDataExportEncryption.ReadOnly =
    new Wrapper(impl)
}
