package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{AccountId, ConfigId}
import scala.jdk.CollectionConverters._
final case class GetStorageLensConfigurationRequest(
    configId: ConfigId,
    accountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest = {
    import GetStorageLensConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest
      .builder()
      .configId(ConfigId.unwrap(configId): java.lang.String)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetStorageLensConfigurationRequest.ReadOnly =
    zio.aws.s3control.model.GetStorageLensConfigurationRequest
      .wrap(buildAwsValue())
}
object GetStorageLensConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetStorageLensConfigurationRequest =
      zio.aws.s3control.model
        .GetStorageLensConfigurationRequest(configId, accountId)
    def configId: ConfigId
    def accountId: AccountId
    def getConfigId: ZIO[Any, Nothing, ConfigId] = ZIO.succeed(configId)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest
  ) extends zio.aws.s3control.model.GetStorageLensConfigurationRequest.ReadOnly {
    override val configId: ConfigId =
      zio.aws.s3control.model.primitives.ConfigId(impl.configId())
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest
  ): zio.aws.s3control.model.GetStorageLensConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
