package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  MultiRegionAccessPointName,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class GetMultiRegionAccessPointPolicyStatusRequest(
    accountId: AccountId,
    name: MultiRegionAccessPointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest = {
    import GetMultiRegionAccessPointPolicyStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(MultiRegionAccessPointName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest.ReadOnly =
    zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
      .wrap(buildAwsValue())
}
object GetMultiRegionAccessPointPolicyStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest =
      zio.aws.s3control.model
        .GetMultiRegionAccessPointPolicyStatusRequest(accountId, name)
    def accountId: AccountId
    def name: MultiRegionAccessPointName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, MultiRegionAccessPointName] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
  ) extends zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: MultiRegionAccessPointName =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
  ): zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest.ReadOnly =
    new Wrapper(impl)
}
