package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  ManifestPrefixString,
  S3BucketArnString,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class S3ManifestOutputLocation(
    expectedManifestBucketOwner: Option[AccountId] = None,
    bucket: S3BucketArnString,
    manifestPrefix: Option[ManifestPrefixString] = None,
    manifestEncryption: Option[
      zio.aws.s3control.model.GeneratedManifestEncryption
    ] = None,
    manifestFormat: zio.aws.s3control.model.GeneratedManifestFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3ManifestOutputLocation = {
    import S3ManifestOutputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3ManifestOutputLocation
      .builder()
      .optionallyWith(
        expectedManifestBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedManifestBucketOwner)
      .bucket(S3BucketArnString.unwrap(bucket): java.lang.String)
      .optionallyWith(
        manifestPrefix.map(value =>
          ManifestPrefixString.unwrap(value): java.lang.String
        )
      )(_.manifestPrefix)
      .optionallyWith(manifestEncryption.map(value => value.buildAwsValue()))(
        _.manifestEncryption
      )
      .manifestFormat(manifestFormat.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3ManifestOutputLocation.ReadOnly =
    zio.aws.s3control.model.S3ManifestOutputLocation.wrap(buildAwsValue())
}
object S3ManifestOutputLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3ManifestOutputLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3ManifestOutputLocation =
      zio.aws.s3control.model.S3ManifestOutputLocation(
        expectedManifestBucketOwner.map(value => value),
        bucket,
        manifestPrefix.map(value => value),
        manifestEncryption.map(value => value.asEditable),
        manifestFormat
      )
    def expectedManifestBucketOwner: Option[AccountId]
    def bucket: S3BucketArnString
    def manifestPrefix: Option[ManifestPrefixString]
    def manifestEncryption
        : Option[zio.aws.s3control.model.GeneratedManifestEncryption.ReadOnly]
    def manifestFormat: zio.aws.s3control.model.GeneratedManifestFormat
    def getExpectedManifestBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField(
        "expectedManifestBucketOwner",
        expectedManifestBucketOwner
      )
    def getBucket: ZIO[Any, Nothing, S3BucketArnString] = ZIO.succeed(bucket)
    def getManifestPrefix: ZIO[Any, AwsError, ManifestPrefixString] =
      AwsError.unwrapOptionField("manifestPrefix", manifestPrefix)
    def getManifestEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.GeneratedManifestEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("manifestEncryption", manifestEncryption)
    def getManifestFormat
        : ZIO[Any, Nothing, zio.aws.s3control.model.GeneratedManifestFormat] =
      ZIO.succeed(manifestFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3ManifestOutputLocation
  ) extends zio.aws.s3control.model.S3ManifestOutputLocation.ReadOnly {
    override val expectedManifestBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedManifestBucketOwner())
      .map(value => zio.aws.s3control.model.primitives.AccountId(value))
    override val bucket: S3BucketArnString =
      zio.aws.s3control.model.primitives.S3BucketArnString(impl.bucket())
    override val manifestPrefix: Option[ManifestPrefixString] = scala
      .Option(impl.manifestPrefix())
      .map(value =>
        zio.aws.s3control.model.primitives.ManifestPrefixString(value)
      )
    override val manifestEncryption
        : Option[zio.aws.s3control.model.GeneratedManifestEncryption.ReadOnly] =
      scala
        .Option(impl.manifestEncryption())
        .map(value =>
          zio.aws.s3control.model.GeneratedManifestEncryption.wrap(value)
        )
    override val manifestFormat
        : zio.aws.s3control.model.GeneratedManifestFormat =
      zio.aws.s3control.model.GeneratedManifestFormat
        .wrap(impl.manifestFormat())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3ManifestOutputLocation
  ): zio.aws.s3control.model.S3ManifestOutputLocation.ReadOnly = new Wrapper(
    impl
  )
}
