package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{AsyncRequestStatus, RegionName}
import scala.jdk.CollectionConverters._
final case class MultiRegionAccessPointRegionalResponse(
    name: Option[RegionName] = None,
    requestStatus: Option[AsyncRequestStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRegionalResponse = {
    import MultiRegionAccessPointRegionalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRegionalResponse
      .builder()
      .optionallyWith(
        name.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        requestStatus.map(value =>
          AsyncRequestStatus.unwrap(value): java.lang.String
        )
      )(_.requestStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse.ReadOnly =
    zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse
      .wrap(buildAwsValue())
}
object MultiRegionAccessPointRegionalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRegionalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse =
      zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse(
        name.map(value => value),
        requestStatus.map(value => value)
      )
    def name: Option[RegionName]
    def requestStatus: Option[AsyncRequestStatus]
    def getName: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("name", name)
    def getRequestStatus: ZIO[Any, AwsError, AsyncRequestStatus] =
      AwsError.unwrapOptionField("requestStatus", requestStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRegionalResponse
  ) extends zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse.ReadOnly {
    override val name: Option[RegionName] = scala
      .Option(impl.name())
      .map(value => zio.aws.s3control.model.primitives.RegionName(value))
    override val requestStatus: Option[AsyncRequestStatus] = scala
      .Option(impl.requestStatus())
      .map(value =>
        zio.aws.s3control.model.primitives.AsyncRequestStatus(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRegionalResponse
  ): zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse.ReadOnly =
    new Wrapper(impl)
}
