package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String
import scala.jdk.CollectionConverters._
final case class ListMultiRegionAccessPointsResponse(
    accessPoints: Option[
      Iterable[zio.aws.s3control.model.MultiRegionAccessPointReport]
    ] = None,
    nextToken: Option[NonEmptyMaxLength1024String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse = {
    import ListMultiRegionAccessPointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse
      .builder()
      .optionallyWith(
        accessPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessPoints)
      .optionallyWith(
        nextToken.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.ReadOnly =
    zio.aws.s3control.model.ListMultiRegionAccessPointsResponse
      .wrap(buildAwsValue())
}
object ListMultiRegionAccessPointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.ListMultiRegionAccessPointsResponse =
      zio.aws.s3control.model.ListMultiRegionAccessPointsResponse(
        accessPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accessPoints: Option[
      List[zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly]
    ]
    def nextToken: Option[NonEmptyMaxLength1024String]
    def getAccessPoints: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly
    ]] = AwsError.unwrapOptionField("accessPoints", accessPoints)
    def getNextToken: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse
  ) extends zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.ReadOnly {
    override val accessPoints: Option[
      List[zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly]
    ] = scala
      .Option(impl.accessPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.MultiRegionAccessPointReport.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse
  ): zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.ReadOnly =
    new Wrapper(impl)
}
