package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMultiRegionAccessPointResponse(
    accessPoint: Option[zio.aws.s3control.model.MultiRegionAccessPointReport] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse = {
    import GetMultiRegionAccessPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse
      .builder()
      .optionallyWith(accessPoint.map(value => value.buildAwsValue()))(
        _.accessPoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetMultiRegionAccessPointResponse.ReadOnly =
    zio.aws.s3control.model.GetMultiRegionAccessPointResponse
      .wrap(buildAwsValue())
}
object GetMultiRegionAccessPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetMultiRegionAccessPointResponse =
      zio.aws.s3control.model.GetMultiRegionAccessPointResponse(
        accessPoint.map(value => value.asEditable)
      )
    def accessPoint
        : Option[zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly]
    def getAccessPoint: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly
    ] = AwsError.unwrapOptionField("accessPoint", accessPoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse
  ) extends zio.aws.s3control.model.GetMultiRegionAccessPointResponse.ReadOnly {
    override val accessPoint: Option[
      zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly
    ] = scala
      .Option(impl.accessPoint())
      .map(value =>
        zio.aws.s3control.model.MultiRegionAccessPointReport.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse
  ): zio.aws.s3control.model.GetMultiRegionAccessPointResponse.ReadOnly =
    new Wrapper(impl)
}
