package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.ObjectLambdaSupportingAccessPointArn
import scala.jdk.CollectionConverters._
final case class ObjectLambdaConfiguration(
    supportingAccessPoint: ObjectLambdaSupportingAccessPointArn,
    cloudWatchMetricsEnabled: Option[Boolean] = None,
    allowedFeatures: Option[
      Iterable[zio.aws.s3control.model.ObjectLambdaAllowedFeature]
    ] = None,
    transformationConfigurations: Iterable[
      zio.aws.s3control.model.ObjectLambdaTransformationConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ObjectLambdaConfiguration = {
    import ObjectLambdaConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ObjectLambdaConfiguration
      .builder()
      .supportingAccessPoint(
        ObjectLambdaSupportingAccessPointArn.unwrap(
          supportingAccessPoint
        ): java.lang.String
      )
      .optionallyWith(
        cloudWatchMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.cloudWatchMetricsEnabled)
      .optionallyWith(
        allowedFeatures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.allowedFeaturesWithStrings)
      .transformationConfigurations(transformationConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly =
    zio.aws.s3control.model.ObjectLambdaConfiguration.wrap(buildAwsValue())
}
object ObjectLambdaConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ObjectLambdaConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ObjectLambdaConfiguration =
      zio.aws.s3control.model.ObjectLambdaConfiguration(
        supportingAccessPoint,
        cloudWatchMetricsEnabled.map(value => value),
        allowedFeatures.map(value => value),
        transformationConfigurations.map { item =>
          item.asEditable
        }
      )
    def supportingAccessPoint: ObjectLambdaSupportingAccessPointArn
    def cloudWatchMetricsEnabled: Option[Boolean]
    def allowedFeatures
        : Option[List[zio.aws.s3control.model.ObjectLambdaAllowedFeature]]
    def transformationConfigurations: List[
      zio.aws.s3control.model.ObjectLambdaTransformationConfiguration.ReadOnly
    ]
    def getSupportingAccessPoint
        : ZIO[Any, Nothing, ObjectLambdaSupportingAccessPointArn] =
      ZIO.succeed(supportingAccessPoint)
    def getCloudWatchMetricsEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("cloudWatchMetricsEnabled", cloudWatchMetricsEnabled)
    def getAllowedFeatures: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.ObjectLambdaAllowedFeature
    ]] = AwsError.unwrapOptionField("allowedFeatures", allowedFeatures)
    def getTransformationConfigurations: ZIO[Any, Nothing, List[
      zio.aws.s3control.model.ObjectLambdaTransformationConfiguration.ReadOnly
    ]] = ZIO.succeed(transformationConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaConfiguration
  ) extends zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly {
    override val supportingAccessPoint: ObjectLambdaSupportingAccessPointArn =
      zio.aws.s3control.model.primitives
        .ObjectLambdaSupportingAccessPointArn(impl.supportingAccessPoint())
    override val cloudWatchMetricsEnabled: Option[Boolean] =
      scala.Option(impl.cloudWatchMetricsEnabled()).map(value => value: Boolean)
    override val allowedFeatures
        : Option[List[zio.aws.s3control.model.ObjectLambdaAllowedFeature]] =
      scala
        .Option(impl.allowedFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.ObjectLambdaAllowedFeature.wrap(item)
          }.toList
        )
    override val transformationConfigurations: List[
      zio.aws.s3control.model.ObjectLambdaTransformationConfiguration.ReadOnly
    ] = impl
      .transformationConfigurations()
      .asScala
      .map { item =>
        zio.aws.s3control.model.ObjectLambdaTransformationConfiguration
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaConfiguration
  ): zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
