package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.Days
import scala.jdk.CollectionConverters._
final case class NoncurrentVersionExpiration(
    noncurrentDays: Option[Days] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration = {
    import NoncurrentVersionExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly =
    zio.aws.s3control.model.NoncurrentVersionExpiration.wrap(buildAwsValue())
}
object NoncurrentVersionExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.NoncurrentVersionExpiration =
      zio.aws.s3control.model
        .NoncurrentVersionExpiration(noncurrentDays.map(value => value))
    def noncurrentDays: Option[Days]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ) extends zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly {
    override val noncurrentDays: Option[Days] = scala
      .Option(impl.noncurrentDays())
      .map(value => zio.aws.s3control.model.primitives.Days(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ): zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly = new Wrapper(
    impl
  )
}
