package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  IAMRoleArn,
  JobArn,
  JobTerminationDate,
  JobStatusUpdateReason,
  JobPriority,
  JobId,
  ConfirmationRequired,
  SuspendedDate,
  SuspendedCause,
  NonEmptyMaxLength256String,
  JobCreationTime
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class JobDescriptor(
    jobId: Option[JobId] = None,
    confirmationRequired: Option[ConfirmationRequired] = None,
    description: Option[NonEmptyMaxLength256String] = None,
    jobArn: Option[JobArn] = None,
    status: Option[zio.aws.s3control.model.JobStatus] = None,
    manifest: Option[zio.aws.s3control.model.JobManifest] = None,
    operation: Option[zio.aws.s3control.model.JobOperation] = None,
    priority: Option[JobPriority] = None,
    progressSummary: Option[zio.aws.s3control.model.JobProgressSummary] = None,
    statusUpdateReason: Option[JobStatusUpdateReason] = None,
    failureReasons: Option[Iterable[zio.aws.s3control.model.JobFailure]] = None,
    report: Option[zio.aws.s3control.model.JobReport] = None,
    creationTime: Option[JobCreationTime] = None,
    terminationDate: Option[JobTerminationDate] = None,
    roleArn: Option[IAMRoleArn] = None,
    suspendedDate: Option[SuspendedDate] = None,
    suspendedCause: Option[SuspendedCause] = None,
    manifestGenerator: Option[zio.aws.s3control.model.JobManifestGenerator] =
      None,
    generatedManifestDescriptor: Option[
      zio.aws.s3control.model.S3GeneratedManifestDescriptor
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobDescriptor = {
    import JobDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobDescriptor
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        confirmationRequired.map(value =>
          ConfirmationRequired.unwrap(value): java.lang.Boolean
        )
      )(_.confirmationRequired)
      .optionallyWith(
        description.map(value =>
          NonEmptyMaxLength256String.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        jobArn.map(value => JobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(manifest.map(value => value.buildAwsValue()))(_.manifest)
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .optionallyWith(
        priority.map(value => JobPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(progressSummary.map(value => value.buildAwsValue()))(
        _.progressSummary
      )
      .optionallyWith(
        statusUpdateReason.map(value =>
          JobStatusUpdateReason.unwrap(value): java.lang.String
        )
      )(_.statusUpdateReason)
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failureReasons)
      .optionallyWith(report.map(value => value.buildAwsValue()))(_.report)
      .optionallyWith(
        creationTime.map(value => JobCreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        terminationDate.map(value => JobTerminationDate.unwrap(value): Instant)
      )(_.terminationDate)
      .optionallyWith(
        roleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        suspendedDate.map(value => SuspendedDate.unwrap(value): Instant)
      )(_.suspendedDate)
      .optionallyWith(
        suspendedCause.map(value =>
          SuspendedCause.unwrap(value): java.lang.String
        )
      )(_.suspendedCause)
      .optionallyWith(manifestGenerator.map(value => value.buildAwsValue()))(
        _.manifestGenerator
      )
      .optionallyWith(
        generatedManifestDescriptor.map(value => value.buildAwsValue())
      )(_.generatedManifestDescriptor)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobDescriptor.ReadOnly =
    zio.aws.s3control.model.JobDescriptor.wrap(buildAwsValue())
}
object JobDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobDescriptor =
      zio.aws.s3control.model.JobDescriptor(
        jobId.map(value => value),
        confirmationRequired.map(value => value),
        description.map(value => value),
        jobArn.map(value => value),
        status.map(value => value),
        manifest.map(value => value.asEditable),
        operation.map(value => value.asEditable),
        priority.map(value => value),
        progressSummary.map(value => value.asEditable),
        statusUpdateReason.map(value => value),
        failureReasons.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        report.map(value => value.asEditable),
        creationTime.map(value => value),
        terminationDate.map(value => value),
        roleArn.map(value => value),
        suspendedDate.map(value => value),
        suspendedCause.map(value => value),
        manifestGenerator.map(value => value.asEditable),
        generatedManifestDescriptor.map(value => value.asEditable)
      )
    def jobId: Option[JobId]
    def confirmationRequired: Option[ConfirmationRequired]
    def description: Option[NonEmptyMaxLength256String]
    def jobArn: Option[JobArn]
    def status: Option[zio.aws.s3control.model.JobStatus]
    def manifest: Option[zio.aws.s3control.model.JobManifest.ReadOnly]
    def operation: Option[zio.aws.s3control.model.JobOperation.ReadOnly]
    def priority: Option[JobPriority]
    def progressSummary
        : Option[zio.aws.s3control.model.JobProgressSummary.ReadOnly]
    def statusUpdateReason: Option[JobStatusUpdateReason]
    def failureReasons
        : Option[List[zio.aws.s3control.model.JobFailure.ReadOnly]]
    def report: Option[zio.aws.s3control.model.JobReport.ReadOnly]
    def creationTime: Option[JobCreationTime]
    def terminationDate: Option[JobTerminationDate]
    def roleArn: Option[IAMRoleArn]
    def suspendedDate: Option[SuspendedDate]
    def suspendedCause: Option[SuspendedCause]
    def manifestGenerator
        : Option[zio.aws.s3control.model.JobManifestGenerator.ReadOnly]
    def generatedManifestDescriptor
        : Option[zio.aws.s3control.model.S3GeneratedManifestDescriptor.ReadOnly]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getConfirmationRequired: ZIO[Any, AwsError, ConfirmationRequired] =
      AwsError.unwrapOptionField("confirmationRequired", confirmationRequired)
    def getDescription: ZIO[Any, AwsError, NonEmptyMaxLength256String] =
      AwsError.unwrapOptionField("description", description)
    def getJobArn: ZIO[Any, AwsError, JobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.s3control.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getManifest
        : ZIO[Any, AwsError, zio.aws.s3control.model.JobManifest.ReadOnly] =
      AwsError.unwrapOptionField("manifest", manifest)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.s3control.model.JobOperation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
    def getPriority: ZIO[Any, AwsError, JobPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getProgressSummary: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.JobProgressSummary.ReadOnly
    ] = AwsError.unwrapOptionField("progressSummary", progressSummary)
    def getStatusUpdateReason: ZIO[Any, AwsError, JobStatusUpdateReason] =
      AwsError.unwrapOptionField("statusUpdateReason", statusUpdateReason)
    def getFailureReasons: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.JobFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failureReasons", failureReasons)
    def getReport
        : ZIO[Any, AwsError, zio.aws.s3control.model.JobReport.ReadOnly] =
      AwsError.unwrapOptionField("report", report)
    def getCreationTime: ZIO[Any, AwsError, JobCreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTerminationDate: ZIO[Any, AwsError, JobTerminationDate] =
      AwsError.unwrapOptionField("terminationDate", terminationDate)
    def getRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSuspendedDate: ZIO[Any, AwsError, SuspendedDate] =
      AwsError.unwrapOptionField("suspendedDate", suspendedDate)
    def getSuspendedCause: ZIO[Any, AwsError, SuspendedCause] =
      AwsError.unwrapOptionField("suspendedCause", suspendedCause)
    def getManifestGenerator: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.JobManifestGenerator.ReadOnly
    ] = AwsError.unwrapOptionField("manifestGenerator", manifestGenerator)
    def getGeneratedManifestDescriptor: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3GeneratedManifestDescriptor.ReadOnly
    ] = AwsError.unwrapOptionField(
      "generatedManifestDescriptor",
      generatedManifestDescriptor
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobDescriptor
  ) extends zio.aws.s3control.model.JobDescriptor.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.s3control.model.primitives.JobId(value))
    override val confirmationRequired: Option[ConfirmationRequired] = scala
      .Option(impl.confirmationRequired())
      .map(value =>
        zio.aws.s3control.model.primitives.ConfirmationRequired(value)
      )
    override val description: Option[NonEmptyMaxLength256String] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength256String(value)
      )
    override val jobArn: Option[JobArn] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.s3control.model.primitives.JobArn(value))
    override val status: Option[zio.aws.s3control.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.s3control.model.JobStatus.wrap(value))
    override val manifest
        : Option[zio.aws.s3control.model.JobManifest.ReadOnly] = scala
      .Option(impl.manifest())
      .map(value => zio.aws.s3control.model.JobManifest.wrap(value))
    override val operation
        : Option[zio.aws.s3control.model.JobOperation.ReadOnly] = scala
      .Option(impl.operation())
      .map(value => zio.aws.s3control.model.JobOperation.wrap(value))
    override val priority: Option[JobPriority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.s3control.model.primitives.JobPriority(value))
    override val progressSummary
        : Option[zio.aws.s3control.model.JobProgressSummary.ReadOnly] = scala
      .Option(impl.progressSummary())
      .map(value => zio.aws.s3control.model.JobProgressSummary.wrap(value))
    override val statusUpdateReason: Option[JobStatusUpdateReason] = scala
      .Option(impl.statusUpdateReason())
      .map(value =>
        zio.aws.s3control.model.primitives.JobStatusUpdateReason(value)
      )
    override val failureReasons
        : Option[List[zio.aws.s3control.model.JobFailure.ReadOnly]] = scala
      .Option(impl.failureReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.JobFailure.wrap(item)
        }.toList
      )
    override val report: Option[zio.aws.s3control.model.JobReport.ReadOnly] =
      scala
        .Option(impl.report())
        .map(value => zio.aws.s3control.model.JobReport.wrap(value))
    override val creationTime: Option[JobCreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.s3control.model.primitives.JobCreationTime(value))
    override val terminationDate: Option[JobTerminationDate] = scala
      .Option(impl.terminationDate())
      .map(value =>
        zio.aws.s3control.model.primitives.JobTerminationDate(value)
      )
    override val roleArn: Option[IAMRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.s3control.model.primitives.IAMRoleArn(value))
    override val suspendedDate: Option[SuspendedDate] = scala
      .Option(impl.suspendedDate())
      .map(value => zio.aws.s3control.model.primitives.SuspendedDate(value))
    override val suspendedCause: Option[SuspendedCause] = scala
      .Option(impl.suspendedCause())
      .map(value => zio.aws.s3control.model.primitives.SuspendedCause(value))
    override val manifestGenerator
        : Option[zio.aws.s3control.model.JobManifestGenerator.ReadOnly] = scala
      .Option(impl.manifestGenerator())
      .map(value => zio.aws.s3control.model.JobManifestGenerator.wrap(value))
    override val generatedManifestDescriptor: Option[
      zio.aws.s3control.model.S3GeneratedManifestDescriptor.ReadOnly
    ] = scala
      .Option(impl.generatedManifestDescriptor())
      .map(value =>
        zio.aws.s3control.model.S3GeneratedManifestDescriptor.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobDescriptor
  ): zio.aws.s3control.model.JobDescriptor.ReadOnly = new Wrapper(impl)
}
