package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{AccountId, ConfigId}
import scala.jdk.CollectionConverters._
final case class PutStorageLensConfigurationRequest(
    configId: ConfigId,
    accountId: AccountId,
    storageLensConfiguration: zio.aws.s3control.model.StorageLensConfiguration,
    tags: Option[Iterable[zio.aws.s3control.model.StorageLensTag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest = {
    import PutStorageLensConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest
      .builder()
      .configId(ConfigId.unwrap(configId): java.lang.String)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .storageLensConfiguration(storageLensConfiguration.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PutStorageLensConfigurationRequest.ReadOnly =
    zio.aws.s3control.model.PutStorageLensConfigurationRequest
      .wrap(buildAwsValue())
}
object PutStorageLensConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PutStorageLensConfigurationRequest =
      zio.aws.s3control.model.PutStorageLensConfigurationRequest(
        configId,
        accountId,
        storageLensConfiguration.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configId: ConfigId
    def accountId: AccountId
    def storageLensConfiguration
        : zio.aws.s3control.model.StorageLensConfiguration.ReadOnly
    def tags: Option[List[zio.aws.s3control.model.StorageLensTag.ReadOnly]]
    def getConfigId: ZIO[Any, Nothing, ConfigId] = ZIO.succeed(configId)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getStorageLensConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.StorageLensConfiguration.ReadOnly
    ] = ZIO.succeed(storageLensConfiguration)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.StorageLensTag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest
  ) extends zio.aws.s3control.model.PutStorageLensConfigurationRequest.ReadOnly {
    override val configId: ConfigId =
      zio.aws.s3control.model.primitives.ConfigId(impl.configId())
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val storageLensConfiguration
        : zio.aws.s3control.model.StorageLensConfiguration.ReadOnly =
      zio.aws.s3control.model.StorageLensConfiguration
        .wrap(impl.storageLensConfiguration())
    override val tags
        : Option[List[zio.aws.s3control.model.StorageLensTag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.StorageLensTag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest
  ): zio.aws.s3control.model.PutStorageLensConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
