package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.IsEnabled
import scala.jdk.CollectionConverters._
final case class PrefixLevelStorageMetrics(
    isEnabled: Option[IsEnabled] = None,
    selectionCriteria: Option[zio.aws.s3control.model.SelectionCriteria] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PrefixLevelStorageMetrics = {
    import PrefixLevelStorageMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PrefixLevelStorageMetrics
      .builder()
      .optionallyWith(
        isEnabled.map(value => IsEnabled.unwrap(value): java.lang.Boolean)
      )(_.isEnabled)
      .optionallyWith(selectionCriteria.map(value => value.buildAwsValue()))(
        _.selectionCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PrefixLevelStorageMetrics.ReadOnly =
    zio.aws.s3control.model.PrefixLevelStorageMetrics.wrap(buildAwsValue())
}
object PrefixLevelStorageMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PrefixLevelStorageMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PrefixLevelStorageMetrics =
      zio.aws.s3control.model.PrefixLevelStorageMetrics(
        isEnabled.map(value => value),
        selectionCriteria.map(value => value.asEditable)
      )
    def isEnabled: Option[IsEnabled]
    def selectionCriteria
        : Option[zio.aws.s3control.model.SelectionCriteria.ReadOnly]
    def getIsEnabled: ZIO[Any, AwsError, IsEnabled] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
    def getSelectionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.SelectionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("selectionCriteria", selectionCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PrefixLevelStorageMetrics
  ) extends zio.aws.s3control.model.PrefixLevelStorageMetrics.ReadOnly {
    override val isEnabled: Option[IsEnabled] = scala
      .Option(impl.isEnabled())
      .map(value => zio.aws.s3control.model.primitives.IsEnabled(value))
    override val selectionCriteria
        : Option[zio.aws.s3control.model.SelectionCriteria.ReadOnly] = scala
      .Option(impl.selectionCriteria())
      .map(value => zio.aws.s3control.model.SelectionCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PrefixLevelStorageMetrics
  ): zio.aws.s3control.model.PrefixLevelStorageMetrics.ReadOnly = new Wrapper(
    impl
  )
}
