package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{Alias, S3AccessPointArn}
import scala.jdk.CollectionConverters._
final case class CreateAccessPointResponse(
    accessPointArn: Option[S3AccessPointArn] = None,
    alias: Option[Alias] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse = {
    import CreateAccessPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse
      .builder()
      .optionallyWith(
        accessPointArn.map(value =>
          S3AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(
        alias.map(value => Alias.unwrap(value): java.lang.String)
      )(_.alias)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.CreateAccessPointResponse.ReadOnly =
    zio.aws.s3control.model.CreateAccessPointResponse.wrap(buildAwsValue())
}
object CreateAccessPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CreateAccessPointResponse =
      zio.aws.s3control.model.CreateAccessPointResponse(
        accessPointArn.map(value => value),
        alias.map(value => value)
      )
    def accessPointArn: Option[S3AccessPointArn]
    def alias: Option[Alias]
    def getAccessPointArn: ZIO[Any, AwsError, S3AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getAlias: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse
  ) extends zio.aws.s3control.model.CreateAccessPointResponse.ReadOnly {
    override val accessPointArn: Option[S3AccessPointArn] = scala
      .Option(impl.accessPointArn())
      .map(value => zio.aws.s3control.model.primitives.S3AccessPointArn(value))
    override val alias: Option[Alias] = scala
      .Option(impl.alias())
      .map(value => zio.aws.s3control.model.primitives.Alias(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse
  ): zio.aws.s3control.model.CreateAccessPointResponse.ReadOnly = new Wrapper(
    impl
  )
}
