package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AsyncResponseDetails(
    multiRegionAccessPointDetails: Option[
      zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse
    ] = None,
    errorDetails: Option[zio.aws.s3control.model.AsyncErrorDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AsyncResponseDetails = {
    import AsyncResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AsyncResponseDetails
      .builder()
      .optionallyWith(
        multiRegionAccessPointDetails.map(value => value.buildAwsValue())
      )(_.multiRegionAccessPointDetails)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AsyncResponseDetails.ReadOnly =
    zio.aws.s3control.model.AsyncResponseDetails.wrap(buildAwsValue())
}
object AsyncResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AsyncResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AsyncResponseDetails =
      zio.aws.s3control.model.AsyncResponseDetails(
        multiRegionAccessPointDetails.map(value => value.asEditable),
        errorDetails.map(value => value.asEditable)
      )
    def multiRegionAccessPointDetails: Option[
      zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse.ReadOnly
    ]
    def errorDetails: Option[zio.aws.s3control.model.AsyncErrorDetails.ReadOnly]
    def getMultiRegionAccessPointDetails: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "multiRegionAccessPointDetails",
      multiRegionAccessPointDetails
    )
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AsyncErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AsyncResponseDetails
  ) extends zio.aws.s3control.model.AsyncResponseDetails.ReadOnly {
    override val multiRegionAccessPointDetails: Option[
      zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse.ReadOnly
    ] = scala
      .Option(impl.multiRegionAccessPointDetails())
      .map(value =>
        zio.aws.s3control.model.MultiRegionAccessPointsAsyncResponse.wrap(value)
      )
    override val errorDetails
        : Option[zio.aws.s3control.model.AsyncErrorDetails.ReadOnly] = scala
      .Option(impl.errorDetails())
      .map(value => zio.aws.s3control.model.AsyncErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AsyncResponseDetails
  ): zio.aws.s3control.model.AsyncResponseDetails.ReadOnly = new Wrapper(impl)
}
