package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  Alias,
  S3AccessPointArn,
  BucketName,
  AccessPointName
}
import scala.jdk.CollectionConverters._
final case class AccessPoint(
    name: AccessPointName,
    networkOrigin: zio.aws.s3control.model.NetworkOrigin,
    vpcConfiguration: Option[zio.aws.s3control.model.VpcConfiguration] = None,
    bucket: BucketName,
    accessPointArn: Option[S3AccessPointArn] = None,
    alias: Option[Alias] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AccessPoint = {
    import AccessPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AccessPoint
      .builder()
      .name(AccessPointName.unwrap(name): java.lang.String)
      .networkOrigin(networkOrigin.unwrap)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        accessPointArn.map(value =>
          S3AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(
        alias.map(value => Alias.unwrap(value): java.lang.String)
      )(_.alias)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AccessPoint.ReadOnly =
    zio.aws.s3control.model.AccessPoint.wrap(buildAwsValue())
}
object AccessPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AccessPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AccessPoint =
      zio.aws.s3control.model.AccessPoint(
        name,
        networkOrigin,
        vpcConfiguration.map(value => value.asEditable),
        bucket,
        accessPointArn.map(value => value),
        alias.map(value => value)
      )
    def name: AccessPointName
    def networkOrigin: zio.aws.s3control.model.NetworkOrigin
    def vpcConfiguration
        : Option[zio.aws.s3control.model.VpcConfiguration.ReadOnly]
    def bucket: BucketName
    def accessPointArn: Option[S3AccessPointArn]
    def alias: Option[Alias]
    def getName: ZIO[Any, Nothing, AccessPointName] = ZIO.succeed(name)
    def getNetworkOrigin
        : ZIO[Any, Nothing, zio.aws.s3control.model.NetworkOrigin] =
      ZIO.succeed(networkOrigin)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getAccessPointArn: ZIO[Any, AwsError, S3AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getAlias: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AccessPoint
  ) extends zio.aws.s3control.model.AccessPoint.ReadOnly {
    override val name: AccessPointName =
      zio.aws.s3control.model.primitives.AccessPointName(impl.name())
    override val networkOrigin: zio.aws.s3control.model.NetworkOrigin =
      zio.aws.s3control.model.NetworkOrigin.wrap(impl.networkOrigin())
    override val vpcConfiguration
        : Option[zio.aws.s3control.model.VpcConfiguration.ReadOnly] = scala
      .Option(impl.vpcConfiguration())
      .map(value => zio.aws.s3control.model.VpcConfiguration.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val accessPointArn: Option[S3AccessPointArn] = scala
      .Option(impl.accessPointArn())
      .map(value => zio.aws.s3control.model.primitives.S3AccessPointArn(value))
    override val alias: Option[Alias] = scala
      .Option(impl.alias())
      .map(value => zio.aws.s3control.model.primitives.Alias(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AccessPoint
  ): zio.aws.s3control.model.AccessPoint.ReadOnly = new Wrapper(impl)
}
