package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MultiRegionAccessPointPolicyDocument(
    established: Option[
      zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy
    ] = None,
    proposed: Option[
      zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument = {
    import MultiRegionAccessPointPolicyDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument
      .builder()
      .optionallyWith(established.map(value => value.buildAwsValue()))(
        _.established
      )
      .optionallyWith(proposed.map(value => value.buildAwsValue()))(_.proposed)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly =
    zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument
      .wrap(buildAwsValue())
}
object MultiRegionAccessPointPolicyDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument =
      zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument(
        established.map(value => value.asEditable),
        proposed.map(value => value.asEditable)
      )
    def established: Option[
      zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly
    ]
    def proposed: Option[
      zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly
    ]
    def getEstablished: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("established", established)
    def getProposed: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("proposed", proposed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument
  ) extends zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly {
    override val established: Option[
      zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly
    ] = scala
      .Option(impl.established())
      .map(value =>
        zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy
          .wrap(value)
      )
    override val proposed: Option[
      zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly
    ] = scala
      .Option(impl.proposed())
      .map(value =>
        zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument
  ): zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly =
    new Wrapper(impl)
}
