package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.ContinuationToken
import scala.jdk.CollectionConverters._
final case class ListStorageLensConfigurationsResponse(
    nextToken: Option[ContinuationToken] = None,
    storageLensConfigurationList: Option[
      Iterable[zio.aws.s3control.model.ListStorageLensConfigurationEntry]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse = {
    import ListStorageLensConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          ContinuationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        storageLensConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageLensConfigurationList)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly =
    zio.aws.s3control.model.ListStorageLensConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListStorageLensConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.ListStorageLensConfigurationsResponse =
      zio.aws.s3control.model.ListStorageLensConfigurationsResponse(
        nextToken.map(value => value),
        storageLensConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[ContinuationToken]
    def storageLensConfigurationList: Option[
      List[zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, ContinuationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStorageLensConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "storageLensConfigurationList",
      storageLensConfigurationList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse
  ) extends zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly {
    override val nextToken: Option[ContinuationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.s3control.model.primitives.ContinuationToken(value))
    override val storageLensConfigurationList: Option[
      List[zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly]
    ] = scala
      .Option(impl.storageLensConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.ListStorageLensConfigurationEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse
  ): zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
