package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{S3AWSRegion, S3BucketArnString}
import scala.jdk.CollectionConverters._
final case class Include(
    buckets: Option[Iterable[S3BucketArnString]] = None,
    regions: Option[Iterable[S3AWSRegion]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.Include = {
    import Include.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.Include
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            S3BucketArnString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            S3AWSRegion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.Include.ReadOnly =
    zio.aws.s3control.model.Include.wrap(buildAwsValue())
}
object Include {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3control.model.Include] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.Include = zio.aws.s3control.model
      .Include(buckets.map(value => value), regions.map(value => value))
    def buckets: Option[List[S3BucketArnString]]
    def regions: Option[List[S3AWSRegion]]
    def getBuckets: ZIO[Any, AwsError, List[S3BucketArnString]] =
      AwsError.unwrapOptionField("buckets", buckets)
    def getRegions: ZIO[Any, AwsError, List[S3AWSRegion]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.Include
  ) extends zio.aws.s3control.model.Include.ReadOnly {
    override val buckets: Option[List[S3BucketArnString]] = scala
      .Option(impl.buckets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.primitives.S3BucketArnString(item)
        }.toList
      )
    override val regions: Option[List[S3AWSRegion]] = scala
      .Option(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.primitives.S3AWSRegion(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.Include
  ): zio.aws.s3control.model.Include.ReadOnly = new Wrapper(impl)
}
