package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.AsyncRequestTokenARN
import scala.jdk.CollectionConverters._
final case class CreateMultiRegionAccessPointResponse(
    requestTokenARN: Option[AsyncRequestTokenARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse = {
    import CreateMultiRegionAccessPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse
      .builder()
      .optionallyWith(
        requestTokenARN.map(value =>
          AsyncRequestTokenARN.unwrap(value): java.lang.String
        )
      )(_.requestTokenARN)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.ReadOnly =
    zio.aws.s3control.model.CreateMultiRegionAccessPointResponse
      .wrap(buildAwsValue())
}
object CreateMultiRegionAccessPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.CreateMultiRegionAccessPointResponse =
      zio.aws.s3control.model.CreateMultiRegionAccessPointResponse(
        requestTokenARN.map(value => value)
      )
    def requestTokenARN: Option[AsyncRequestTokenARN]
    def getRequestTokenARN: ZIO[Any, AwsError, AsyncRequestTokenARN] =
      AwsError.unwrapOptionField("requestTokenARN", requestTokenARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse
  ) extends zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.ReadOnly {
    override val requestTokenARN: Option[AsyncRequestTokenARN] = scala
      .Option(impl.requestTokenARN())
      .map(value =>
        zio.aws.s3control.model.primitives.AsyncRequestTokenARN(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse
  ): zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.ReadOnly =
    new Wrapper(impl)
}
