package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength64String,
  IAMRoleArn,
  AccountId,
  JobPriority,
  ConfirmationRequired,
  NonEmptyMaxLength256String
}
import scala.jdk.CollectionConverters._
final case class CreateJobRequest(
    accountId: AccountId,
    confirmationRequired: Option[ConfirmationRequired] = None,
    operation: zio.aws.s3control.model.JobOperation,
    report: zio.aws.s3control.model.JobReport,
    clientRequestToken: NonEmptyMaxLength64String,
    manifest: Option[zio.aws.s3control.model.JobManifest] = None,
    description: Option[NonEmptyMaxLength256String] = None,
    priority: JobPriority,
    roleArn: IAMRoleArn,
    tags: Option[Iterable[zio.aws.s3control.model.S3Tag]] = None,
    manifestGenerator: Option[zio.aws.s3control.model.JobManifestGenerator] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateJobRequest = {
    import CreateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateJobRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        confirmationRequired.map(value =>
          ConfirmationRequired.unwrap(value): java.lang.Boolean
        )
      )(_.confirmationRequired)
      .operation(operation.buildAwsValue())
      .report(report.buildAwsValue())
      .clientRequestToken(
        NonEmptyMaxLength64String.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(manifest.map(value => value.buildAwsValue()))(_.manifest)
      .optionallyWith(
        description.map(value =>
          NonEmptyMaxLength256String.unwrap(value): java.lang.String
        )
      )(_.description)
      .priority(JobPriority.unwrap(priority): Integer)
      .roleArn(IAMRoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(manifestGenerator.map(value => value.buildAwsValue()))(
        _.manifestGenerator
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.CreateJobRequest.ReadOnly =
    zio.aws.s3control.model.CreateJobRequest.wrap(buildAwsValue())
}
object CreateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CreateJobRequest =
      zio.aws.s3control.model.CreateJobRequest(
        accountId,
        confirmationRequired.map(value => value),
        operation.asEditable,
        report.asEditable,
        clientRequestToken,
        manifest.map(value => value.asEditable),
        description.map(value => value),
        priority,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        manifestGenerator.map(value => value.asEditable)
      )
    def accountId: AccountId
    def confirmationRequired: Option[ConfirmationRequired]
    def operation: zio.aws.s3control.model.JobOperation.ReadOnly
    def report: zio.aws.s3control.model.JobReport.ReadOnly
    def clientRequestToken: NonEmptyMaxLength64String
    def manifest: Option[zio.aws.s3control.model.JobManifest.ReadOnly]
    def description: Option[NonEmptyMaxLength256String]
    def priority: JobPriority
    def roleArn: IAMRoleArn
    def tags: Option[List[zio.aws.s3control.model.S3Tag.ReadOnly]]
    def manifestGenerator
        : Option[zio.aws.s3control.model.JobManifestGenerator.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getConfirmationRequired: ZIO[Any, AwsError, ConfirmationRequired] =
      AwsError.unwrapOptionField("confirmationRequired", confirmationRequired)
    def getOperation
        : ZIO[Any, Nothing, zio.aws.s3control.model.JobOperation.ReadOnly] =
      ZIO.succeed(operation)
    def getReport
        : ZIO[Any, Nothing, zio.aws.s3control.model.JobReport.ReadOnly] =
      ZIO.succeed(report)
    def getClientRequestToken: ZIO[Any, Nothing, NonEmptyMaxLength64String] =
      ZIO.succeed(clientRequestToken)
    def getManifest
        : ZIO[Any, AwsError, zio.aws.s3control.model.JobManifest.ReadOnly] =
      AwsError.unwrapOptionField("manifest", manifest)
    def getDescription: ZIO[Any, AwsError, NonEmptyMaxLength256String] =
      AwsError.unwrapOptionField("description", description)
    def getPriority: ZIO[Any, Nothing, JobPriority] = ZIO.succeed(priority)
    def getRoleArn: ZIO[Any, Nothing, IAMRoleArn] = ZIO.succeed(roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getManifestGenerator: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.JobManifestGenerator.ReadOnly
    ] = AwsError.unwrapOptionField("manifestGenerator", manifestGenerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateJobRequest
  ) extends zio.aws.s3control.model.CreateJobRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val confirmationRequired: Option[ConfirmationRequired] = scala
      .Option(impl.confirmationRequired())
      .map(value =>
        zio.aws.s3control.model.primitives.ConfirmationRequired(value)
      )
    override val operation: zio.aws.s3control.model.JobOperation.ReadOnly =
      zio.aws.s3control.model.JobOperation.wrap(impl.operation())
    override val report: zio.aws.s3control.model.JobReport.ReadOnly =
      zio.aws.s3control.model.JobReport.wrap(impl.report())
    override val clientRequestToken: NonEmptyMaxLength64String =
      zio.aws.s3control.model.primitives
        .NonEmptyMaxLength64String(impl.clientRequestToken())
    override val manifest
        : Option[zio.aws.s3control.model.JobManifest.ReadOnly] = scala
      .Option(impl.manifest())
      .map(value => zio.aws.s3control.model.JobManifest.wrap(value))
    override val description: Option[NonEmptyMaxLength256String] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength256String(value)
      )
    override val priority: JobPriority =
      zio.aws.s3control.model.primitives.JobPriority(impl.priority())
    override val roleArn: IAMRoleArn =
      zio.aws.s3control.model.primitives.IAMRoleArn(impl.roleArn())
    override val tags: Option[List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.S3Tag.wrap(item)
          }.toList
        )
    override val manifestGenerator
        : Option[zio.aws.s3control.model.JobManifestGenerator.ReadOnly] = scala
      .Option(impl.manifestGenerator())
      .map(value => zio.aws.s3control.model.JobManifestGenerator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateJobRequest
  ): zio.aws.s3control.model.CreateJobRequest.ReadOnly = new Wrapper(impl)
}
