package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{RegionName, BucketName}
import scala.jdk.CollectionConverters._
final case class RegionReport(
    bucket: Option[BucketName] = None,
    region: Option[RegionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.RegionReport = {
    import RegionReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.RegionReport
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        region.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.RegionReport.ReadOnly =
    zio.aws.s3control.model.RegionReport.wrap(buildAwsValue())
}
object RegionReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.RegionReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.RegionReport =
      zio.aws.s3control.model
        .RegionReport(bucket.map(value => value), region.map(value => value))
    def bucket: Option[BucketName]
    def region: Option[RegionName]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getRegion: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.RegionReport
  ) extends zio.aws.s3control.model.RegionReport.ReadOnly {
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.BucketName(value))
    override val region: Option[RegionName] = scala
      .Option(impl.region())
      .map(value => zio.aws.s3control.model.primitives.RegionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.RegionReport
  ): zio.aws.s3control.model.RegionReport.ReadOnly = new Wrapper(impl)
}
