package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobOperation(
    lambdaInvoke: Option[zio.aws.s3control.model.LambdaInvokeOperation] = None,
    s3PutObjectCopy: Option[zio.aws.s3control.model.S3CopyObjectOperation] =
      None,
    s3PutObjectAcl: Option[zio.aws.s3control.model.S3SetObjectAclOperation] =
      None,
    s3PutObjectTagging: Option[
      zio.aws.s3control.model.S3SetObjectTaggingOperation
    ] = None,
    s3DeleteObjectTagging: Option[
      zio.aws.s3control.model.S3DeleteObjectTaggingOperation
    ] = None,
    s3InitiateRestoreObject: Option[
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation
    ] = None,
    s3PutObjectLegalHold: Option[
      zio.aws.s3control.model.S3SetObjectLegalHoldOperation
    ] = None,
    s3PutObjectRetention: Option[
      zio.aws.s3control.model.S3SetObjectRetentionOperation
    ] = None,
    s3ReplicateObject: Option[
      zio.aws.s3control.model.S3ReplicateObjectOperation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobOperation = {
    import JobOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobOperation
      .builder()
      .optionallyWith(lambdaInvoke.map(value => value.buildAwsValue()))(
        _.lambdaInvoke
      )
      .optionallyWith(s3PutObjectCopy.map(value => value.buildAwsValue()))(
        _.s3PutObjectCopy
      )
      .optionallyWith(s3PutObjectAcl.map(value => value.buildAwsValue()))(
        _.s3PutObjectAcl
      )
      .optionallyWith(s3PutObjectTagging.map(value => value.buildAwsValue()))(
        _.s3PutObjectTagging
      )
      .optionallyWith(
        s3DeleteObjectTagging.map(value => value.buildAwsValue())
      )(_.s3DeleteObjectTagging)
      .optionallyWith(
        s3InitiateRestoreObject.map(value => value.buildAwsValue())
      )(_.s3InitiateRestoreObject)
      .optionallyWith(s3PutObjectLegalHold.map(value => value.buildAwsValue()))(
        _.s3PutObjectLegalHold
      )
      .optionallyWith(s3PutObjectRetention.map(value => value.buildAwsValue()))(
        _.s3PutObjectRetention
      )
      .optionallyWith(s3ReplicateObject.map(value => value.buildAwsValue()))(
        _.s3ReplicateObject
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobOperation.ReadOnly =
    zio.aws.s3control.model.JobOperation.wrap(buildAwsValue())
}
object JobOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobOperation =
      zio.aws.s3control.model.JobOperation(
        lambdaInvoke.map(value => value.asEditable),
        s3PutObjectCopy.map(value => value.asEditable),
        s3PutObjectAcl.map(value => value.asEditable),
        s3PutObjectTagging.map(value => value.asEditable),
        s3DeleteObjectTagging.map(value => value.asEditable),
        s3InitiateRestoreObject.map(value => value.asEditable),
        s3PutObjectLegalHold.map(value => value.asEditable),
        s3PutObjectRetention.map(value => value.asEditable),
        s3ReplicateObject.map(value => value.asEditable)
      )
    def lambdaInvoke
        : Option[zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly]
    def s3PutObjectCopy
        : Option[zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly]
    def s3PutObjectAcl
        : Option[zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly]
    def s3PutObjectTagging
        : Option[zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly]
    def s3DeleteObjectTagging: Option[
      zio.aws.s3control.model.S3DeleteObjectTaggingOperation.ReadOnly
    ]
    def s3InitiateRestoreObject: Option[
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly
    ]
    def s3PutObjectLegalHold
        : Option[zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly]
    def s3PutObjectRetention
        : Option[zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly]
    def s3ReplicateObject
        : Option[zio.aws.s3control.model.S3ReplicateObjectOperation.ReadOnly]
    def getLambdaInvoke: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaInvoke", lambdaInvoke)
    def getS3PutObjectCopy: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectCopy", s3PutObjectCopy)
    def getS3PutObjectAcl: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectAcl", s3PutObjectAcl)
    def getS3PutObjectTagging: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectTagging", s3PutObjectTagging)
    def getS3DeleteObjectTagging: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3DeleteObjectTaggingOperation.ReadOnly
    ] =
      AwsError.unwrapOptionField("s3DeleteObjectTagging", s3DeleteObjectTagging)
    def getS3InitiateRestoreObject: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3InitiateRestoreObject",
      s3InitiateRestoreObject
    )
    def getS3PutObjectLegalHold: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectLegalHold", s3PutObjectLegalHold)
    def getS3PutObjectRetention: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3PutObjectRetention", s3PutObjectRetention)
    def getS3ReplicateObject: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3ReplicateObjectOperation.ReadOnly
    ] = AwsError.unwrapOptionField("s3ReplicateObject", s3ReplicateObject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobOperation
  ) extends zio.aws.s3control.model.JobOperation.ReadOnly {
    override val lambdaInvoke
        : Option[zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly] = scala
      .Option(impl.lambdaInvoke())
      .map(value => zio.aws.s3control.model.LambdaInvokeOperation.wrap(value))
    override val s3PutObjectCopy
        : Option[zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly] = scala
      .Option(impl.s3PutObjectCopy())
      .map(value => zio.aws.s3control.model.S3CopyObjectOperation.wrap(value))
    override val s3PutObjectAcl
        : Option[zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly] =
      scala
        .Option(impl.s3PutObjectAcl())
        .map(value =>
          zio.aws.s3control.model.S3SetObjectAclOperation.wrap(value)
        )
    override val s3PutObjectTagging
        : Option[zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly] =
      scala
        .Option(impl.s3PutObjectTagging())
        .map(value =>
          zio.aws.s3control.model.S3SetObjectTaggingOperation.wrap(value)
        )
    override val s3DeleteObjectTagging: Option[
      zio.aws.s3control.model.S3DeleteObjectTaggingOperation.ReadOnly
    ] = scala
      .Option(impl.s3DeleteObjectTagging())
      .map(value =>
        zio.aws.s3control.model.S3DeleteObjectTaggingOperation.wrap(value)
      )
    override val s3InitiateRestoreObject: Option[
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly
    ] = scala
      .Option(impl.s3InitiateRestoreObject())
      .map(value =>
        zio.aws.s3control.model.S3InitiateRestoreObjectOperation.wrap(value)
      )
    override val s3PutObjectLegalHold: Option[
      zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly
    ] = scala
      .Option(impl.s3PutObjectLegalHold())
      .map(value =>
        zio.aws.s3control.model.S3SetObjectLegalHoldOperation.wrap(value)
      )
    override val s3PutObjectRetention: Option[
      zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly
    ] = scala
      .Option(impl.s3PutObjectRetention())
      .map(value =>
        zio.aws.s3control.model.S3SetObjectRetentionOperation.wrap(value)
      )
    override val s3ReplicateObject
        : Option[zio.aws.s3control.model.S3ReplicateObjectOperation.ReadOnly] =
      scala
        .Option(impl.s3ReplicateObject())
        .map(value =>
          zio.aws.s3control.model.S3ReplicateObjectOperation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobOperation
  ): zio.aws.s3control.model.JobOperation.ReadOnly = new Wrapper(impl)
}
