package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GeneratedManifestEncryption(
    sses3: Option[zio.aws.s3control.model.SSES3Encryption] = None,
    ssekms: Option[zio.aws.s3control.model.SSEKMSEncryption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GeneratedManifestEncryption = {
    import GeneratedManifestEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GeneratedManifestEncryption
      .builder()
      .optionallyWith(sses3.map(value => value.buildAwsValue()))(_.sses3)
      .optionallyWith(ssekms.map(value => value.buildAwsValue()))(_.ssekms)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GeneratedManifestEncryption.ReadOnly =
    zio.aws.s3control.model.GeneratedManifestEncryption.wrap(buildAwsValue())
}
object GeneratedManifestEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GeneratedManifestEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GeneratedManifestEncryption =
      zio.aws.s3control.model.GeneratedManifestEncryption(
        sses3.map(value => value.asEditable),
        ssekms.map(value => value.asEditable)
      )
    def sses3: Option[zio.aws.s3control.model.SSES3Encryption.ReadOnly]
    def ssekms: Option[zio.aws.s3control.model.SSEKMSEncryption.ReadOnly]
    def getSses3
        : ZIO[Any, AwsError, zio.aws.s3control.model.SSES3Encryption.ReadOnly] =
      AwsError.unwrapOptionField("sses3", sses3)
    def getSsekms: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.SSEKMSEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("ssekms", ssekms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GeneratedManifestEncryption
  ) extends zio.aws.s3control.model.GeneratedManifestEncryption.ReadOnly {
    override val sses3
        : Option[zio.aws.s3control.model.SSES3Encryption.ReadOnly] = scala
      .Option(impl.sses3())
      .map(value => zio.aws.s3control.model.SSES3Encryption.wrap(value))
    override val ssekms
        : Option[zio.aws.s3control.model.SSEKMSEncryption.ReadOnly] = scala
      .Option(impl.ssekms())
      .map(value => zio.aws.s3control.model.SSEKMSEncryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GeneratedManifestEncryption
  ): zio.aws.s3control.model.GeneratedManifestEncryption.ReadOnly = new Wrapper(
    impl
  )
}
