package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String
import scala.jdk.CollectionConverters._
final case class S3ObjectOwner(
    id: Option[NonEmptyMaxLength1024String] = None,
    displayName: Option[NonEmptyMaxLength1024String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3ObjectOwner = {
    import S3ObjectOwner.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3ObjectOwner
      .builder()
      .optionallyWith(
        id.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        displayName.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3ObjectOwner.ReadOnly =
    zio.aws.s3control.model.S3ObjectOwner.wrap(buildAwsValue())
}
object S3ObjectOwner {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3ObjectOwner
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3ObjectOwner =
      zio.aws.s3control.model
        .S3ObjectOwner(id.map(value => value), displayName.map(value => value))
    def id: Option[NonEmptyMaxLength1024String]
    def displayName: Option[NonEmptyMaxLength1024String]
    def getId: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("id", id)
    def getDisplayName: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3ObjectOwner
  ) extends zio.aws.s3control.model.S3ObjectOwner.ReadOnly {
    override val id: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val displayName: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3ObjectOwner
  ): zio.aws.s3control.model.S3ObjectOwner.ReadOnly = new Wrapper(impl)
}
