package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait S3MetadataDirective {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.S3MetadataDirective
}
object S3MetadataDirective {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3MetadataDirective
  ): zio.aws.s3control.model.S3MetadataDirective = value match {
    case software.amazon.awssdk.services.s3control.model.S3MetadataDirective.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3MetadataDirective.COPY =>
      val r = COPY
      r
    case software.amazon.awssdk.services.s3control.model.S3MetadataDirective.REPLACE =>
      val r = REPLACE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.S3MetadataDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3MetadataDirective =
      software.amazon.awssdk.services.s3control.model.S3MetadataDirective.UNKNOWN_TO_SDK_VERSION
  }
  case object COPY extends zio.aws.s3control.model.S3MetadataDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3MetadataDirective =
      software.amazon.awssdk.services.s3control.model.S3MetadataDirective.COPY
  }
  case object REPLACE extends zio.aws.s3control.model.S3MetadataDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3MetadataDirective =
      software.amazon.awssdk.services.s3control.model.S3MetadataDirective.REPLACE
  }
}
