package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMultiRegionAccessPointPolicyStatusResponse(
    established: Option[zio.aws.s3control.model.PolicyStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse = {
    import GetMultiRegionAccessPointPolicyStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse
      .builder()
      .optionallyWith(established.map(value => value.buildAwsValue()))(
        _.established
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.ReadOnly =
    zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse
      .wrap(buildAwsValue())
}
object GetMultiRegionAccessPointPolicyStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse =
      zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse(
        established.map(value => value.asEditable)
      )
    def established: Option[zio.aws.s3control.model.PolicyStatus.ReadOnly]
    def getEstablished
        : ZIO[Any, AwsError, zio.aws.s3control.model.PolicyStatus.ReadOnly] =
      AwsError.unwrapOptionField("established", established)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse
  ) extends zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.ReadOnly {
    override val established
        : Option[zio.aws.s3control.model.PolicyStatus.ReadOnly] = scala
      .Option(impl.established())
      .map(value => zio.aws.s3control.model.PolicyStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse
  ): zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.ReadOnly =
    new Wrapper(impl)
}
