package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength64String,
  AccessPointName,
  NonEmptyMaxLength1024String,
  BucketName,
  Alias,
  S3AccessPointArn,
  CreationDate
}
import scala.jdk.CollectionConverters._
final case class GetAccessPointResponse(
    name: Option[AccessPointName] = None,
    bucket: Option[BucketName] = None,
    networkOrigin: Option[zio.aws.s3control.model.NetworkOrigin] = None,
    vpcConfiguration: Option[zio.aws.s3control.model.VpcConfiguration] = None,
    publicAccessBlockConfiguration: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration
    ] = None,
    creationDate: Option[CreationDate] = None,
    alias: Option[Alias] = None,
    accessPointArn: Option[S3AccessPointArn] = None,
    endpoints: Option[
      Map[NonEmptyMaxLength64String, NonEmptyMaxLength1024String]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointResponse = {
    import GetAccessPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointResponse
      .builder()
      .optionallyWith(
        name.map(value => AccessPointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(networkOrigin.map(value => value.unwrap))(_.networkOrigin)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        alias.map(value => Alias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(
        accessPointArn.map(value =>
          S3AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(
        endpoints.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyMaxLength64String
                .unwrap(key): java.lang.String) -> (NonEmptyMaxLength1024String
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.endpoints)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetAccessPointResponse.ReadOnly =
    zio.aws.s3control.model.GetAccessPointResponse.wrap(buildAwsValue())
}
object GetAccessPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetAccessPointResponse =
      zio.aws.s3control.model.GetAccessPointResponse(
        name.map(value => value),
        bucket.map(value => value),
        networkOrigin.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        publicAccessBlockConfiguration.map(value => value.asEditable),
        creationDate.map(value => value),
        alias.map(value => value),
        accessPointArn.map(value => value),
        endpoints.map(value => value)
      )
    def name: Option[AccessPointName]
    def bucket: Option[BucketName]
    def networkOrigin: Option[zio.aws.s3control.model.NetworkOrigin]
    def vpcConfiguration
        : Option[zio.aws.s3control.model.VpcConfiguration.ReadOnly]
    def publicAccessBlockConfiguration: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def creationDate: Option[CreationDate]
    def alias: Option[Alias]
    def accessPointArn: Option[S3AccessPointArn]
    def endpoints
        : Option[Map[NonEmptyMaxLength64String, NonEmptyMaxLength1024String]]
    def getName: ZIO[Any, AwsError, AccessPointName] =
      AwsError.unwrapOptionField("name", name)
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getNetworkOrigin
        : ZIO[Any, AwsError, zio.aws.s3control.model.NetworkOrigin] =
      AwsError.unwrapOptionField("networkOrigin", networkOrigin)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getAlias: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("alias", alias)
    def getAccessPointArn: ZIO[Any, AwsError, S3AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getEndpoints: ZIO[Any, AwsError, Map[
      NonEmptyMaxLength64String,
      NonEmptyMaxLength1024String
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointResponse
  ) extends zio.aws.s3control.model.GetAccessPointResponse.ReadOnly {
    override val name: Option[AccessPointName] = scala
      .Option(impl.name())
      .map(value => zio.aws.s3control.model.primitives.AccessPointName(value))
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.BucketName(value))
    override val networkOrigin: Option[zio.aws.s3control.model.NetworkOrigin] =
      scala
        .Option(impl.networkOrigin())
        .map(value => zio.aws.s3control.model.NetworkOrigin.wrap(value))
    override val vpcConfiguration
        : Option[zio.aws.s3control.model.VpcConfiguration.ReadOnly] = scala
      .Option(impl.vpcConfiguration())
      .map(value => zio.aws.s3control.model.VpcConfiguration.wrap(value))
    override val publicAccessBlockConfiguration: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = scala
      .Option(impl.publicAccessBlockConfiguration())
      .map(value =>
        zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(value)
      )
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.s3control.model.primitives.CreationDate(value))
    override val alias: Option[Alias] = scala
      .Option(impl.alias())
      .map(value => zio.aws.s3control.model.primitives.Alias(value))
    override val accessPointArn: Option[S3AccessPointArn] = scala
      .Option(impl.accessPointArn())
      .map(value => zio.aws.s3control.model.primitives.S3AccessPointArn(value))
    override val endpoints
        : Option[Map[NonEmptyMaxLength64String, NonEmptyMaxLength1024String]] =
      scala
        .Option(impl.endpoints())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.s3control.model.primitives.NonEmptyMaxLength64String(
                key
              ) -> zio.aws.s3control.model.primitives
                .NonEmptyMaxLength1024String(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointResponse
  ): zio.aws.s3control.model.GetAccessPointResponse.ReadOnly = new Wrapper(impl)
}
