package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.JobId
import scala.jdk.CollectionConverters._
final case class CreateJobResponse(jobId: Option[JobId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateJobResponse = {
    import CreateJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.CreateJobResponse.ReadOnly =
    zio.aws.s3control.model.CreateJobResponse.wrap(buildAwsValue())
}
object CreateJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CreateJobResponse =
      zio.aws.s3control.model.CreateJobResponse(jobId.map(value => value))
    def jobId: Option[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateJobResponse
  ) extends zio.aws.s3control.model.CreateJobResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.s3control.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateJobResponse
  ): zio.aws.s3control.model.CreateJobResponse.ReadOnly = new Wrapper(impl)
}
