package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AsyncRequestParameters(
    createMultiRegionAccessPointRequest: Option[
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput
    ] = None,
    deleteMultiRegionAccessPointRequest: Option[
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput
    ] = None,
    putMultiRegionAccessPointPolicyRequest: Option[
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AsyncRequestParameters = {
    import AsyncRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AsyncRequestParameters
      .builder()
      .optionallyWith(
        createMultiRegionAccessPointRequest.map(value => value.buildAwsValue())
      )(_.createMultiRegionAccessPointRequest)
      .optionallyWith(
        deleteMultiRegionAccessPointRequest.map(value => value.buildAwsValue())
      )(_.deleteMultiRegionAccessPointRequest)
      .optionallyWith(
        putMultiRegionAccessPointPolicyRequest.map(value =>
          value.buildAwsValue()
        )
      )(_.putMultiRegionAccessPointPolicyRequest)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AsyncRequestParameters.ReadOnly =
    zio.aws.s3control.model.AsyncRequestParameters.wrap(buildAwsValue())
}
object AsyncRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AsyncRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AsyncRequestParameters =
      zio.aws.s3control.model.AsyncRequestParameters(
        createMultiRegionAccessPointRequest.map(value => value.asEditable),
        deleteMultiRegionAccessPointRequest.map(value => value.asEditable),
        putMultiRegionAccessPointPolicyRequest.map(value => value.asEditable)
      )
    def createMultiRegionAccessPointRequest: Option[
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly
    ]
    def deleteMultiRegionAccessPointRequest: Option[
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly
    ]
    def putMultiRegionAccessPointPolicyRequest: Option[
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly
    ]
    def getCreateMultiRegionAccessPointRequest: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createMultiRegionAccessPointRequest",
      createMultiRegionAccessPointRequest
    )
    def getDeleteMultiRegionAccessPointRequest: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deleteMultiRegionAccessPointRequest",
      deleteMultiRegionAccessPointRequest
    )
    def getPutMultiRegionAccessPointPolicyRequest: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "putMultiRegionAccessPointPolicyRequest",
      putMultiRegionAccessPointPolicyRequest
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AsyncRequestParameters
  ) extends zio.aws.s3control.model.AsyncRequestParameters.ReadOnly {
    override val createMultiRegionAccessPointRequest: Option[
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly
    ] = scala
      .Option(impl.createMultiRegionAccessPointRequest())
      .map(value =>
        zio.aws.s3control.model.CreateMultiRegionAccessPointInput.wrap(value)
      )
    override val deleteMultiRegionAccessPointRequest: Option[
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly
    ] = scala
      .Option(impl.deleteMultiRegionAccessPointRequest())
      .map(value =>
        zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.wrap(value)
      )
    override val putMultiRegionAccessPointPolicyRequest: Option[
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly
    ] = scala
      .Option(impl.putMultiRegionAccessPointPolicyRequest())
      .map(value =>
        zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AsyncRequestParameters
  ): zio.aws.s3control.model.AsyncRequestParameters.ReadOnly = new Wrapper(impl)
}
