package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.Prefix
import scala.jdk.CollectionConverters._
final case class LifecycleRuleAndOperator(
    prefix: Option[Prefix] = None,
    tags: Option[Iterable[zio.aws.s3control.model.S3Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.LifecycleRuleAndOperator = {
    import LifecycleRuleAndOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.LifecycleRuleAndOperator
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly =
    zio.aws.s3control.model.LifecycleRuleAndOperator.wrap(buildAwsValue())
}
object LifecycleRuleAndOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.LifecycleRuleAndOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.LifecycleRuleAndOperator =
      zio.aws.s3control.model.LifecycleRuleAndOperator(
        prefix.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def prefix: Option[Prefix]
    def tags: Option[List[zio.aws.s3control.model.S3Tag.ReadOnly]]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleRuleAndOperator
  ) extends zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly {
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3control.model.primitives.Prefix(value))
    override val tags: Option[List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.S3Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleRuleAndOperator
  ): zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly = new Wrapper(
    impl
  )
}
