package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  ReportPrefixString,
  S3BucketArnString
}
import scala.jdk.CollectionConverters._
final case class JobReport(
    bucket: Option[S3BucketArnString] = None,
    format: Option[zio.aws.s3control.model.JobReportFormat] = None,
    enabled: Boolean,
    prefix: Option[ReportPrefixString] = None,
    reportScope: Option[zio.aws.s3control.model.JobReportScope] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobReport = {
    import JobReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobReport
      .builder()
      .optionallyWith(
        bucket.map(value => S3BucketArnString.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        prefix.map(value => ReportPrefixString.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(reportScope.map(value => value.unwrap))(_.reportScope)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobReport.ReadOnly =
    zio.aws.s3control.model.JobReport.wrap(buildAwsValue())
}
object JobReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobReport =
      zio.aws.s3control.model.JobReport(
        bucket.map(value => value),
        format.map(value => value),
        enabled,
        prefix.map(value => value),
        reportScope.map(value => value)
      )
    def bucket: Option[S3BucketArnString]
    def format: Option[zio.aws.s3control.model.JobReportFormat]
    def enabled: Boolean
    def prefix: Option[ReportPrefixString]
    def reportScope: Option[zio.aws.s3control.model.JobReportScope]
    def getBucket: ZIO[Any, AwsError, S3BucketArnString] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getFormat: ZIO[Any, AwsError, zio.aws.s3control.model.JobReportFormat] =
      AwsError.unwrapOptionField("format", format)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getPrefix: ZIO[Any, AwsError, ReportPrefixString] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getReportScope
        : ZIO[Any, AwsError, zio.aws.s3control.model.JobReportScope] =
      AwsError.unwrapOptionField("reportScope", reportScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobReport
  ) extends zio.aws.s3control.model.JobReport.ReadOnly {
    override val bucket: Option[S3BucketArnString] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.S3BucketArnString(value))
    override val format: Option[zio.aws.s3control.model.JobReportFormat] = scala
      .Option(impl.format())
      .map(value => zio.aws.s3control.model.JobReportFormat.wrap(value))
    override val enabled: Boolean = impl.enabled(): Boolean
    override val prefix: Option[ReportPrefixString] = scala
      .Option(impl.prefix())
      .map(value =>
        zio.aws.s3control.model.primitives.ReportPrefixString(value)
      )
    override val reportScope: Option[zio.aws.s3control.model.JobReportScope] =
      scala
        .Option(impl.reportScope())
        .map(value => zio.aws.s3control.model.JobReportScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobReport
  ): zio.aws.s3control.model.JobReport.ReadOnly = new Wrapper(impl)
}
