package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength1024String,
  S3ObjectVersionId,
  S3KeyArnString
}
import scala.jdk.CollectionConverters._
final case class JobManifestLocation(
    objectArn: S3KeyArnString,
    objectVersionId: Option[S3ObjectVersionId] = None,
    eTag: NonEmptyMaxLength1024String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobManifestLocation = {
    import JobManifestLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobManifestLocation
      .builder()
      .objectArn(S3KeyArnString.unwrap(objectArn): java.lang.String)
      .optionallyWith(
        objectVersionId.map(value =>
          S3ObjectVersionId.unwrap(value): java.lang.String
        )
      )(_.objectVersionId)
      .eTag(NonEmptyMaxLength1024String.unwrap(eTag): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobManifestLocation.ReadOnly =
    zio.aws.s3control.model.JobManifestLocation.wrap(buildAwsValue())
}
object JobManifestLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobManifestLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobManifestLocation =
      zio.aws.s3control.model.JobManifestLocation(
        objectArn,
        objectVersionId.map(value => value),
        eTag
      )
    def objectArn: S3KeyArnString
    def objectVersionId: Option[S3ObjectVersionId]
    def eTag: NonEmptyMaxLength1024String
    def getObjectArn: ZIO[Any, Nothing, S3KeyArnString] = ZIO.succeed(objectArn)
    def getObjectVersionId: ZIO[Any, AwsError, S3ObjectVersionId] =
      AwsError.unwrapOptionField("objectVersionId", objectVersionId)
    def getETag: ZIO[Any, Nothing, NonEmptyMaxLength1024String] =
      ZIO.succeed(eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobManifestLocation
  ) extends zio.aws.s3control.model.JobManifestLocation.ReadOnly {
    override val objectArn: S3KeyArnString =
      zio.aws.s3control.model.primitives.S3KeyArnString(impl.objectArn())
    override val objectVersionId: Option[S3ObjectVersionId] = scala
      .Option(impl.objectVersionId())
      .map(value => zio.aws.s3control.model.primitives.S3ObjectVersionId(value))
    override val eTag: NonEmptyMaxLength1024String =
      zio.aws.s3control.model.primitives
        .NonEmptyMaxLength1024String(impl.eTag())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobManifestLocation
  ): zio.aws.s3control.model.JobManifestLocation.ReadOnly = new Wrapper(impl)
}
