package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait ObjectLambdaAllowedFeature {
  def unwrap: software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature
}
object ObjectLambdaAllowedFeature {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature
  ): zio.aws.s3control.model.ObjectLambdaAllowedFeature = value match {
    case software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature.GET_OBJECT_RANGE =>
      val r = `GetObject-Range`
      r
    case software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature.GET_OBJECT_PART_NUMBER =>
      val r = `GetObject-PartNumber`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ObjectLambdaAllowedFeature {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature.UNKNOWN_TO_SDK_VERSION
  }
  case object `GetObject-Range`
      extends zio.aws.s3control.model.ObjectLambdaAllowedFeature {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature.GET_OBJECT_RANGE
  }
  case object `GetObject-PartNumber`
      extends zio.aws.s3control.model.ObjectLambdaAllowedFeature {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature.GET_OBJECT_PART_NUMBER
  }
}
