package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  CreationDate,
  ObjectLambdaAccessPointName
}
import scala.jdk.CollectionConverters._
final case class GetAccessPointForObjectLambdaResponse(
    name: Option[ObjectLambdaAccessPointName] = None,
    publicAccessBlockConfiguration: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration
    ] = None,
    creationDate: Option[CreationDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse = {
    import GetAccessPointForObjectLambdaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse
      .builder()
      .optionallyWith(
        name.map(value =>
          ObjectLambdaAccessPointName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly =
    zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse
      .wrap(buildAwsValue())
}
object GetAccessPointForObjectLambdaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse =
      zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse(
        name.map(value => value),
        publicAccessBlockConfiguration.map(value => value.asEditable),
        creationDate.map(value => value)
      )
    def name: Option[ObjectLambdaAccessPointName]
    def publicAccessBlockConfiguration: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def creationDate: Option[CreationDate]
    def getName: ZIO[Any, AwsError, ObjectLambdaAccessPointName] =
      AwsError.unwrapOptionField("name", name)
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse
  ) extends zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly {
    override val name: Option[ObjectLambdaAccessPointName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.s3control.model.primitives.ObjectLambdaAccessPointName(value)
      )
    override val publicAccessBlockConfiguration: Option[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = scala
      .Option(impl.publicAccessBlockConfiguration())
      .map(value =>
        zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(value)
      )
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.s3control.model.primitives.CreationDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse
  ): zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly =
    new Wrapper(impl)
}
