package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.ObjectLambdaPolicy
import scala.jdk.CollectionConverters._
final case class GetAccessPointPolicyForObjectLambdaResponse(
    policy: Option[ObjectLambdaPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse = {
    import GetAccessPointPolicyForObjectLambdaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse
      .builder()
      .optionallyWith(
        policy.map(value => ObjectLambdaPolicy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.ReadOnly =
    zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse
      .wrap(buildAwsValue())
}
object GetAccessPointPolicyForObjectLambdaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse =
      zio.aws.s3control.model
        .GetAccessPointPolicyForObjectLambdaResponse(policy.map(value => value))
    def policy: Option[ObjectLambdaPolicy]
    def getPolicy: ZIO[Any, AwsError, ObjectLambdaPolicy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse
  ) extends zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.ReadOnly {
    override val policy: Option[ObjectLambdaPolicy] = scala
      .Option(impl.policy())
      .map(value =>
        zio.aws.s3control.model.primitives.ObjectLambdaPolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse
  ): zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.ReadOnly =
    new Wrapper(impl)
}
