package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3AccessControlList(
    owner: zio.aws.s3control.model.S3ObjectOwner,
    grants: Option[Iterable[zio.aws.s3control.model.S3Grant]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3AccessControlList = {
    import S3AccessControlList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3AccessControlList
      .builder()
      .owner(owner.buildAwsValue())
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3AccessControlList.ReadOnly =
    zio.aws.s3control.model.S3AccessControlList.wrap(buildAwsValue())
}
object S3AccessControlList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3AccessControlList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3AccessControlList =
      zio.aws.s3control.model.S3AccessControlList(
        owner.asEditable,
        grants.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def owner: zio.aws.s3control.model.S3ObjectOwner.ReadOnly
    def grants: Option[List[zio.aws.s3control.model.S3Grant.ReadOnly]]
    def getOwner
        : ZIO[Any, Nothing, zio.aws.s3control.model.S3ObjectOwner.ReadOnly] =
      ZIO.succeed(owner)
    def getGrants
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Grant.ReadOnly]] =
      AwsError.unwrapOptionField("grants", grants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3AccessControlList
  ) extends zio.aws.s3control.model.S3AccessControlList.ReadOnly {
    override val owner: zio.aws.s3control.model.S3ObjectOwner.ReadOnly =
      zio.aws.s3control.model.S3ObjectOwner.wrap(impl.owner())
    override val grants
        : Option[List[zio.aws.s3control.model.S3Grant.ReadOnly]] = scala
      .Option(impl.grants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.S3Grant.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3AccessControlList
  ): zio.aws.s3control.model.S3AccessControlList.ReadOnly = new Wrapper(impl)
}
