package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait OperationName {
  def unwrap: software.amazon.awssdk.services.s3control.model.OperationName
}
object OperationName {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.OperationName
  ): zio.aws.s3control.model.OperationName = value match {
    case software.amazon.awssdk.services.s3control.model.OperationName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.OperationName.LAMBDA_INVOKE =>
      val r = LambdaInvoke
      r
    case software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_COPY =>
      val r = S3PutObjectCopy
      r
    case software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_ACL =>
      val r = S3PutObjectAcl
      r
    case software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_TAGGING =>
      val r = S3PutObjectTagging
      r
    case software.amazon.awssdk.services.s3control.model.OperationName.S3_DELETE_OBJECT_TAGGING =>
      val r = S3DeleteObjectTagging
      r
    case software.amazon.awssdk.services.s3control.model.OperationName.S3_INITIATE_RESTORE_OBJECT =>
      val r = S3InitiateRestoreObject
      r
    case software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_LEGAL_HOLD =>
      val r = S3PutObjectLegalHold
      r
    case software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_RETENTION =>
      val r = S3PutObjectRetention
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.UNKNOWN_TO_SDK_VERSION
  }
  case object LambdaInvoke extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.LAMBDA_INVOKE
  }
  case object S3PutObjectCopy extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_COPY
  }
  case object S3PutObjectAcl extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_ACL
  }
  case object S3PutObjectTagging extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_TAGGING
  }
  case object S3DeleteObjectTagging
      extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.S3_DELETE_OBJECT_TAGGING
  }
  case object S3InitiateRestoreObject
      extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.S3_INITIATE_RESTORE_OBJECT
  }
  case object S3PutObjectLegalHold
      extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_LEGAL_HOLD
  }
  case object S3PutObjectRetention
      extends zio.aws.s3control.model.OperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.OperationName =
      software.amazon.awssdk.services.s3control.model.OperationName.S3_PUT_OBJECT_RETENTION
  }
}
