package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String
import scala.jdk.CollectionConverters._
final case class ListAccessPointsResponse(
    accessPointList: Option[Iterable[zio.aws.s3control.model.AccessPoint]] =
      None,
    nextToken: Option[NonEmptyMaxLength1024String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse = {
    import ListAccessPointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse
      .builder()
      .optionallyWith(
        accessPointList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessPointList)
      .optionallyWith(
        nextToken.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ListAccessPointsResponse.ReadOnly =
    zio.aws.s3control.model.ListAccessPointsResponse.wrap(buildAwsValue())
}
object ListAccessPointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListAccessPointsResponse =
      zio.aws.s3control.model.ListAccessPointsResponse(
        accessPointList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accessPointList
        : Option[List[zio.aws.s3control.model.AccessPoint.ReadOnly]]
    def nextToken: Option[NonEmptyMaxLength1024String]
    def getAccessPointList: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.AccessPoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessPointList", accessPointList)
    def getNextToken: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse
  ) extends zio.aws.s3control.model.ListAccessPointsResponse.ReadOnly {
    override val accessPointList
        : Option[List[zio.aws.s3control.model.AccessPoint.ReadOnly]] = scala
      .Option(impl.accessPointList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.AccessPoint.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse
  ): zio.aws.s3control.model.ListAccessPointsResponse.ReadOnly = new Wrapper(
    impl
  )
}
