package zio.aws.s3control
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength64String,
  S3BucketArnString,
  MaxLength1024String,
  S3AWSRegion,
  NonEmptyMaxLength1024String
}
import zio.aws.s3control.model.primitives.SuspendedCause.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessPointName extends Subtype[String]
    type AccessPointName =
      zio.aws.s3control.model.primitives.AccessPointName.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.s3control.model.primitives.AccountId.Type
    object Alias extends Subtype[String]
    type Alias = zio.aws.s3control.model.primitives.Alias.Type
    object AsyncCreationTimestamp extends Subtype[Instant]
    type AsyncCreationTimestamp =
      zio.aws.s3control.model.primitives.AsyncCreationTimestamp.Type
    object AsyncRequestStatus extends Subtype[String]
    type AsyncRequestStatus =
      zio.aws.s3control.model.primitives.AsyncRequestStatus.Type
    object AsyncRequestTokenARN extends Subtype[String]
    type AsyncRequestTokenARN =
      zio.aws.s3control.model.primitives.AsyncRequestTokenARN.Type
    object AwsLambdaTransformationPayload extends Subtype[String]
    type AwsLambdaTransformationPayload =
      zio.aws.s3control.model.primitives.AwsLambdaTransformationPayload.Type
    object AwsOrgArn extends Subtype[String]
    type AwsOrgArn = zio.aws.s3control.model.primitives.AwsOrgArn.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.s3control.model.primitives.BucketName.Type
    object ConfigId extends Subtype[String]
    type ConfigId = zio.aws.s3control.model.primitives.ConfigId.Type
    object ConfirmRemoveSelfBucketAccess extends Subtype[Boolean]
    type ConfirmRemoveSelfBucketAccess =
      zio.aws.s3control.model.primitives.ConfirmRemoveSelfBucketAccess.Type
    object ConfirmationRequired extends Subtype[Boolean]
    type ConfirmationRequired =
      zio.aws.s3control.model.primitives.ConfirmationRequired.Type
    object ContinuationToken extends Subtype[String]
    type ContinuationToken =
      zio.aws.s3control.model.primitives.ContinuationToken.Type
    object CreationDate extends Subtype[Instant]
    type CreationDate = zio.aws.s3control.model.primitives.CreationDate.Type
    object CreationTimestamp extends Subtype[Instant]
    type CreationTimestamp =
      zio.aws.s3control.model.primitives.CreationTimestamp.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.s3control.model.primitives.Date.Type
    object Days extends Subtype[Int]
    type Days = zio.aws.s3control.model.primitives.Days.Type
    object DaysAfterInitiation extends Subtype[Int]
    type DaysAfterInitiation =
      zio.aws.s3control.model.primitives.DaysAfterInitiation.Type
    object ExpiredObjectDeleteMarker extends Subtype[Boolean]
    type ExpiredObjectDeleteMarker =
      zio.aws.s3control.model.primitives.ExpiredObjectDeleteMarker.Type
    object FunctionArnString extends Subtype[String]
    type FunctionArnString =
      zio.aws.s3control.model.primitives.FunctionArnString.Type
    object GrantFullControl extends Subtype[String]
    type GrantFullControl =
      zio.aws.s3control.model.primitives.GrantFullControl.Type
    object GrantRead extends Subtype[String]
    type GrantRead = zio.aws.s3control.model.primitives.GrantRead.Type
    object GrantReadACP extends Subtype[String]
    type GrantReadACP = zio.aws.s3control.model.primitives.GrantReadACP.Type
    object GrantWrite extends Subtype[String]
    type GrantWrite = zio.aws.s3control.model.primitives.GrantWrite.Type
    object GrantWriteACP extends Subtype[String]
    type GrantWriteACP = zio.aws.s3control.model.primitives.GrantWriteACP.Type
    object IAMRoleArn extends Subtype[String]
    type IAMRoleArn = zio.aws.s3control.model.primitives.IAMRoleArn.Type
    object ID extends Subtype[String]
    type ID = zio.aws.s3control.model.primitives.ID.Type
    object IsEnabled extends Subtype[Boolean]
    type IsEnabled = zio.aws.s3control.model.primitives.IsEnabled.Type
    object IsPublic extends Subtype[Boolean]
    type IsPublic = zio.aws.s3control.model.primitives.IsPublic.Type
    object JobArn extends Subtype[String]
    type JobArn = zio.aws.s3control.model.primitives.JobArn.Type
    object JobCreationTime extends Subtype[Instant]
    type JobCreationTime =
      zio.aws.s3control.model.primitives.JobCreationTime.Type
    object JobFailureCode extends Subtype[String]
    type JobFailureCode = zio.aws.s3control.model.primitives.JobFailureCode.Type
    object JobFailureReason extends Subtype[String]
    type JobFailureReason =
      zio.aws.s3control.model.primitives.JobFailureReason.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.s3control.model.primitives.JobId.Type
    object JobNumberOfTasksFailed extends Subtype[Long]
    type JobNumberOfTasksFailed =
      zio.aws.s3control.model.primitives.JobNumberOfTasksFailed.Type
    object JobNumberOfTasksSucceeded extends Subtype[Long]
    type JobNumberOfTasksSucceeded =
      zio.aws.s3control.model.primitives.JobNumberOfTasksSucceeded.Type
    object JobPriority extends Subtype[Int]
    type JobPriority = zio.aws.s3control.model.primitives.JobPriority.Type
    object JobStatusUpdateReason extends Subtype[String]
    type JobStatusUpdateReason =
      zio.aws.s3control.model.primitives.JobStatusUpdateReason.Type
    object JobTerminationDate extends Subtype[Instant]
    type JobTerminationDate =
      zio.aws.s3control.model.primitives.JobTerminationDate.Type
    object JobTotalNumberOfTasks extends Subtype[Long]
    type JobTotalNumberOfTasks =
      zio.aws.s3control.model.primitives.JobTotalNumberOfTasks.Type
    object KmsKeyArnString extends Subtype[String]
    type KmsKeyArnString =
      zio.aws.s3control.model.primitives.KmsKeyArnString.Type
    object Location extends Subtype[String]
    type Location = zio.aws.s3control.model.primitives.Location.Type
    object MaxLength1024String extends Subtype[String]
    type MaxLength1024String =
      zio.aws.s3control.model.primitives.MaxLength1024String.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.s3control.model.primitives.MaxResults.Type
    object MinStorageBytesPercentage extends Subtype[Double]
    type MinStorageBytesPercentage =
      zio.aws.s3control.model.primitives.MinStorageBytesPercentage.Type
    object MultiRegionAccessPointAlias extends Subtype[String]
    type MultiRegionAccessPointAlias =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointAlias.Type
    object MultiRegionAccessPointClientToken extends Subtype[String]
    type MultiRegionAccessPointClientToken =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointClientToken.Type
    object MultiRegionAccessPointName extends Subtype[String]
    type MultiRegionAccessPointName =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointName.Type
    object NonEmptyMaxLength1024String extends Subtype[String]
    type NonEmptyMaxLength1024String =
      zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String.Type
    object NonEmptyMaxLength2048String extends Subtype[String]
    type NonEmptyMaxLength2048String =
      zio.aws.s3control.model.primitives.NonEmptyMaxLength2048String.Type
    object NonEmptyMaxLength256String extends Subtype[String]
    type NonEmptyMaxLength256String =
      zio.aws.s3control.model.primitives.NonEmptyMaxLength256String.Type
    object NonEmptyMaxLength64String extends Subtype[String]
    type NonEmptyMaxLength64String =
      zio.aws.s3control.model.primitives.NonEmptyMaxLength64String.Type
    object ObjectLambdaAccessPointArn extends Subtype[String]
    type ObjectLambdaAccessPointArn =
      zio.aws.s3control.model.primitives.ObjectLambdaAccessPointArn.Type
    object ObjectLambdaAccessPointName extends Subtype[String]
    type ObjectLambdaAccessPointName =
      zio.aws.s3control.model.primitives.ObjectLambdaAccessPointName.Type
    object ObjectLambdaPolicy extends Subtype[String]
    type ObjectLambdaPolicy =
      zio.aws.s3control.model.primitives.ObjectLambdaPolicy.Type
    object ObjectLambdaSupportingAccessPointArn extends Subtype[String]
    type ObjectLambdaSupportingAccessPointArn =
      zio.aws.s3control.model.primitives.ObjectLambdaSupportingAccessPointArn.Type
    object ObjectLockEnabledForBucket extends Subtype[Boolean]
    type ObjectLockEnabledForBucket =
      zio.aws.s3control.model.primitives.ObjectLockEnabledForBucket.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.s3control.model.primitives.Policy.Type
    object Prefix extends Subtype[String]
    type Prefix = zio.aws.s3control.model.primitives.Prefix.Type
    object PublicAccessBlockEnabled extends Subtype[Boolean]
    type PublicAccessBlockEnabled =
      zio.aws.s3control.model.primitives.PublicAccessBlockEnabled.Type
    object RegionName extends Subtype[String]
    type RegionName = zio.aws.s3control.model.primitives.RegionName.Type
    object ReportPrefixString extends Subtype[String]
    type ReportPrefixString =
      zio.aws.s3control.model.primitives.ReportPrefixString.Type
    object S3AWSRegion extends Subtype[String]
    type S3AWSRegion = zio.aws.s3control.model.primitives.S3AWSRegion.Type
    object S3AccessPointArn extends Subtype[String]
    type S3AccessPointArn =
      zio.aws.s3control.model.primitives.S3AccessPointArn.Type
    object S3BucketArnString extends Subtype[String]
    type S3BucketArnString =
      zio.aws.s3control.model.primitives.S3BucketArnString.Type
    object S3ContentLength extends Subtype[Long]
    type S3ContentLength =
      zio.aws.s3control.model.primitives.S3ContentLength.Type
    object S3ExpirationInDays extends Subtype[Int]
    type S3ExpirationInDays =
      zio.aws.s3control.model.primitives.S3ExpirationInDays.Type
    object S3KeyArnString extends Subtype[String]
    type S3KeyArnString = zio.aws.s3control.model.primitives.S3KeyArnString.Type
    object S3ObjectVersionId extends Subtype[String]
    type S3ObjectVersionId =
      zio.aws.s3control.model.primitives.S3ObjectVersionId.Type
    object S3RegionalBucketArn extends Subtype[String]
    type S3RegionalBucketArn =
      zio.aws.s3control.model.primitives.S3RegionalBucketArn.Type
    object SSEKMSKeyId extends Subtype[String]
    type SSEKMSKeyId = zio.aws.s3control.model.primitives.SSEKMSKeyId.Type
    object Setting extends Subtype[Boolean]
    type Setting = zio.aws.s3control.model.primitives.Setting.Type
    object StorageLensArn extends Subtype[String]
    type StorageLensArn = zio.aws.s3control.model.primitives.StorageLensArn.Type
    object StorageLensPrefixLevelDelimiter extends Subtype[String]
    type StorageLensPrefixLevelDelimiter =
      zio.aws.s3control.model.primitives.StorageLensPrefixLevelDelimiter.Type
    object StorageLensPrefixLevelMaxDepth extends Subtype[Int]
    type StorageLensPrefixLevelMaxDepth =
      zio.aws.s3control.model.primitives.StorageLensPrefixLevelMaxDepth.Type
    object StringForNextToken extends Subtype[String]
    type StringForNextToken =
      zio.aws.s3control.model.primitives.StringForNextToken.Type
    object SuspendedCause extends Subtype[String]
    type SuspendedCause = zio.aws.s3control.model.primitives.SuspendedCause.Type
    object SuspendedDate extends Subtype[Instant]
    type SuspendedDate = zio.aws.s3control.model.primitives.SuspendedDate.Type
    object TagKeyString extends Subtype[String]
    type TagKeyString = zio.aws.s3control.model.primitives.TagKeyString.Type
    object TagValueString extends Subtype[String]
    type TagValueString = zio.aws.s3control.model.primitives.TagValueString.Type
    object TimeStamp extends Subtype[Instant]
    type TimeStamp = zio.aws.s3control.model.primitives.TimeStamp.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.s3control.model.primitives.VpcId.Type
  }
  type AccessPointList = List[zio.aws.s3control.model.AccessPoint]
  type Buckets = List[S3BucketArnString]
  type Endpoints = Map[NonEmptyMaxLength64String, NonEmptyMaxLength1024String]
  type JobFailureList = List[zio.aws.s3control.model.JobFailure]
  type JobListDescriptorList = List[zio.aws.s3control.model.JobListDescriptor]
  type JobManifestFieldList = List[zio.aws.s3control.model.JobManifestFieldName]
  type JobStatusList = List[zio.aws.s3control.model.JobStatus]
  type LifecycleRules = List[zio.aws.s3control.model.LifecycleRule]
  type MultiRegionAccessPointRegionalResponseList =
    List[zio.aws.s3control.model.MultiRegionAccessPointRegionalResponse]
  type MultiRegionAccessPointReportList =
    List[zio.aws.s3control.model.MultiRegionAccessPointReport]
  type NoncurrentVersionTransitionList =
    List[zio.aws.s3control.model.NoncurrentVersionTransition]
  type ObjectLambdaAccessPointList =
    List[zio.aws.s3control.model.ObjectLambdaAccessPoint]
  type ObjectLambdaAllowedFeaturesList =
    List[zio.aws.s3control.model.ObjectLambdaAllowedFeature]
  type ObjectLambdaTransformationConfigurationActionsList =
    List[zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction]
  type ObjectLambdaTransformationConfigurationsList =
    List[zio.aws.s3control.model.ObjectLambdaTransformationConfiguration]
  type RegionCreationList = List[zio.aws.s3control.model.Region]
  type RegionReportList = List[zio.aws.s3control.model.RegionReport]
  type RegionalBucketList = List[zio.aws.s3control.model.RegionalBucket]
  type Regions = List[S3AWSRegion]
  type S3GrantList = List[zio.aws.s3control.model.S3Grant]
  type S3TagSet = List[zio.aws.s3control.model.S3Tag]
  type S3UserMetadata = Map[NonEmptyMaxLength1024String, MaxLength1024String]
  type StorageLensConfigurationList =
    List[zio.aws.s3control.model.ListStorageLensConfigurationEntry]
  type StorageLensTags = List[zio.aws.s3control.model.StorageLensTag]
  type TransitionList = List[zio.aws.s3control.model.Transition]
}
