package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  MaxResults,
  StringForNextToken,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    accountId: AccountId,
    jobStatuses: Option[Iterable[zio.aws.s3control.model.JobStatus]] = None,
    nextToken: Option[StringForNextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListJobsRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        jobStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.jobStatusesWithStrings)
      .optionallyWith(
        nextToken.map(value =>
          StringForNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ListJobsRequest.ReadOnly =
    zio.aws.s3control.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListJobsRequest =
      zio.aws.s3control.model.ListJobsRequest(
        accountId,
        jobStatuses.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def accountId: AccountId
    def jobStatuses: Option[List[zio.aws.s3control.model.JobStatus]]
    def nextToken: Option[StringForNextToken]
    def maxResults: Option[MaxResults]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getJobStatuses
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.JobStatus]] =
      AwsError.unwrapOptionField("jobStatuses", jobStatuses)
    def getNextToken: ZIO[Any, AwsError, StringForNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListJobsRequest
  ) extends zio.aws.s3control.model.ListJobsRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val jobStatuses: Option[List[zio.aws.s3control.model.JobStatus]] =
      scala
        .Option(impl.jobStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.JobStatus.wrap(item)
          }.toList
        )
    override val nextToken: Option[StringForNextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.s3control.model.primitives.StringForNextToken(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.s3control.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListJobsRequest
  ): zio.aws.s3control.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
